/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.Callback;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsInWhenPresent<T>
extends AbstractListValueCondition<T, IsInWhenPresent<T>> {
    protected IsInWhenPresent(Builder<T> builder) {
        super(builder);
    }

    @Override
    public String renderCondition(String columnName, Stream<String> placeholders) {
        return StringUtilities.spaceAfter(columnName) + placeholders.collect(Collectors.joining(",", "in (", ")"));
    }

    @Override
    public IsInWhenPresent<T> withListEmptyCallback(Callback callback) {
        return ((Builder)((Builder)((Builder)new Builder().withValues(this.values)).withValueStreamTransformer(this.valueStreamTransformer)).withEmptyCallback(callback)).build();
    }

    @SafeVarargs
    public static <T> IsInWhenPresent<T> of(T ... values) {
        return IsInWhenPresent.of(Arrays.asList(values));
    }

    public static <T> IsInWhenPresent<T> of(Collection<T> values) {
        return ((Builder)((Builder)new Builder<T>().withValues(values)).withValueStreamTransformer(s -> s.filter(Objects::nonNull))).build();
    }

    public static class Builder<T>
    extends AbstractListValueCondition.AbstractListConditionBuilder<T, Builder<T>> {
        @Override
        protected Builder<T> getThis() {
            return this;
        }

        protected IsInWhenPresent<T> build() {
            return new IsInWhenPresent(this);
        }
    }
}

