/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.Callback;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsInCaseInsensitive
extends AbstractListValueCondition<String, IsInCaseInsensitive> {
    protected IsInCaseInsensitive(Builder builder) {
        super(builder);
    }

    @Override
    public String renderCondition(String columnName, Stream<String> placeholders) {
        return "upper(" + columnName + ") " + placeholders.collect(Collectors.joining(",", "in (", ")"));
    }

    @Override
    public IsInCaseInsensitive withListEmptyCallback(Callback callback) {
        return ((Builder)((Builder)((Builder)new Builder().withValues(this.values)).withValueStreamTransformer(this.valueStreamTransformer)).withEmptyCallback(callback)).build();
    }

    public static IsInCaseInsensitive of(String ... values) {
        return IsInCaseInsensitive.of(Arrays.asList(values));
    }

    public static IsInCaseInsensitive of(Collection<String> values) {
        return ((Builder)((Builder)new Builder().withValues(values)).withValueStreamTransformer(s -> s.map(StringUtilities::safelyUpperCase))).build();
    }

    public static class Builder
    extends AbstractListValueCondition.AbstractListConditionBuilder<String, Builder> {
        @Override
        protected Builder getThis() {
            return this;
        }

        protected IsInCaseInsensitive build() {
            return new IsInCaseInsensitive(this);
        }
    }
}

