/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.Callback;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsIn<T>
extends AbstractListValueCondition<T, IsIn<T>> {
    protected IsIn(Builder<T> builder) {
        super(builder);
    }

    @Override
    public String renderCondition(String columnName, Stream<String> placeholders) {
        return StringUtilities.spaceAfter(columnName) + placeholders.collect(Collectors.joining(",", "in (", ")"));
    }

    @Override
    public IsIn<T> withListEmptyCallback(Callback callback) {
        return ((Builder)((Builder)((Builder)new Builder().withValues(this.values)).withValueStreamTransformer(this.valueStreamTransformer)).withEmptyCallback(callback)).build();
    }

    public IsIn<T> then(UnaryOperator<Stream<T>> valueStreamTransformer) {
        return ((Builder)((Builder)((Builder)new Builder().withValues(this.values)).withValueStreamTransformer(valueStreamTransformer)).withEmptyCallback(this.emptyCallback)).build();
    }

    @SafeVarargs
    public static <T> IsIn<T> of(T ... values) {
        return IsIn.of(Arrays.asList(values));
    }

    public static <T> IsIn<T> of(Collection<T> values) {
        return ((Builder)new Builder<T>().withValues(values)).build();
    }

    public static class Builder<T>
    extends AbstractListValueCondition.AbstractListConditionBuilder<T, Builder<T>> {
        @Override
        protected Builder<T> getThis() {
            return this;
        }

        public IsIn<T> build() {
            return new IsIn(this);
        }
    }
}

