/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.where.WhereApplier;
import org.mybatis.dynamic.sql.where.WhereModel;

public abstract class AbstractWhereDSL<T extends AbstractWhereDSL<T>> {
    private final List<SqlCriterion<?>> criteria = new ArrayList();

    protected AbstractWhereDSL() {
    }

    @NotNull
    public <S> T where(BindableColumn<S> column, VisitableCondition<S> condition) {
        this.addCriterion(column, condition);
        return this.getThis();
    }

    @NotNull
    public <S> T where(BindableColumn<S> column, VisitableCondition<S> condition, SqlCriterion<?> ... subCriteria) {
        this.addCriterion(column, condition, Arrays.asList(subCriteria));
        return this.getThis();
    }

    @NotNull
    public <S> T where(BindableColumn<S> column, VisitableCondition<S> condition, List<SqlCriterion<?>> subCriteria) {
        this.addCriterion(column, condition, subCriteria);
        return this.getThis();
    }

    @NotNull
    public T applyWhere(WhereApplier whereApplier) {
        whereApplier.accept(this);
        return this.getThis();
    }

    @NotNull
    public <S> T and(BindableColumn<S> column, VisitableCondition<S> condition) {
        this.addCriterion("and", column, condition);
        return this.getThis();
    }

    @NotNull
    public <S> T and(BindableColumn<S> column, VisitableCondition<S> condition, SqlCriterion<?> ... subCriteria) {
        this.addCriterion("and", column, condition, Arrays.asList(subCriteria));
        return this.getThis();
    }

    @NotNull
    public <S> T and(BindableColumn<S> column, VisitableCondition<S> condition, List<SqlCriterion<?>> subCriteria) {
        this.addCriterion("and", column, condition, subCriteria);
        return this.getThis();
    }

    @NotNull
    public <S> T or(BindableColumn<S> column, VisitableCondition<S> condition) {
        this.addCriterion("or", column, condition);
        return this.getThis();
    }

    @NotNull
    public <S> T or(BindableColumn<S> column, VisitableCondition<S> condition, SqlCriterion<?> ... subCriteria) {
        this.addCriterion("or", column, condition, Arrays.asList(subCriteria));
        return this.getThis();
    }

    @NotNull
    public <S> T or(BindableColumn<S> column, VisitableCondition<S> condition, List<SqlCriterion<?>> subCriteria) {
        this.addCriterion("or", column, condition, subCriteria);
        return this.getThis();
    }

    private <S> void addCriterion(BindableColumn<S> column, VisitableCondition<S> condition) {
        SqlCriterion<S> criterion = SqlCriterion.withColumn(column).withCondition(condition).build();
        this.criteria.add(criterion);
    }

    private <S> void addCriterion(String connector, BindableColumn<S> column, VisitableCondition<S> condition) {
        SqlCriterion<S> criterion = SqlCriterion.withColumn(column).withConnector(connector).withCondition(condition).build();
        this.criteria.add(criterion);
    }

    private <S> void addCriterion(BindableColumn<S> column, VisitableCondition<S> condition, List<SqlCriterion<?>> subCriteria) {
        SqlCriterion<S> criterion = SqlCriterion.withColumn(column).withCondition(condition).withSubCriteria(subCriteria).build();
        this.criteria.add(criterion);
    }

    private <S> void addCriterion(String connector, BindableColumn<S> column, VisitableCondition<S> condition, List<SqlCriterion<?>> subCriteria) {
        SqlCriterion<S> criterion = SqlCriterion.withColumn(column).withConnector(connector).withCondition(condition).withSubCriteria(subCriteria).build();
        this.criteria.add(criterion);
    }

    protected WhereModel internalBuild() {
        return WhereModel.of(this.criteria);
    }

    protected abstract WhereModel buildWhereModel();

    protected abstract T getThis();
}

