/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.GroupByModel;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.join.JoinModel;
import org.mybatis.dynamic.sql.select.render.JoinRenderer;
import org.mybatis.dynamic.sql.util.CustomCollectors;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.StringUtilities;
import org.mybatis.dynamic.sql.where.WhereModel;
import org.mybatis.dynamic.sql.where.render.WhereClauseProvider;
import org.mybatis.dynamic.sql.where.render.WhereRenderer;

public class QueryExpressionRenderer {
    private final QueryExpressionModel queryExpression;
    private final RenderingStrategy renderingStrategy;
    private final AtomicInteger sequence;

    private QueryExpressionRenderer(Builder builder) {
        this.queryExpression = Objects.requireNonNull(builder.queryExpression);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
        this.sequence = Objects.requireNonNull(builder.sequence);
    }

    public FragmentAndParameters render() {
        return this.queryExpression.whereModel().flatMap(this::renderWhereClause).map(this::renderWithWhereClause).orElseGet(this::renderWithoutWhereClause);
    }

    private FragmentAndParameters renderWithWhereClause(WhereClauseProvider whereClause) {
        return FragmentAndParameters.withFragment(this.calculateQueryExpression(whereClause)).withParameters(whereClause.getParameters()).build();
    }

    private FragmentAndParameters renderWithoutWhereClause() {
        return FragmentAndParameters.withFragment(this.calculateQueryExpression()).build();
    }

    private String calculateQueryExpression() {
        return this.calculateQueryExpressionStart() + StringUtilities.spaceBefore(this.queryExpression.groupByModel().map(this::renderGroupBy));
    }

    private String calculateQueryExpression(WhereClauseProvider whereClause) {
        return this.calculateQueryExpressionStart() + StringUtilities.spaceBefore(whereClause.getWhereClause()) + StringUtilities.spaceBefore(this.queryExpression.groupByModel().map(this::renderGroupBy));
    }

    private String calculateQueryExpressionStart() {
        return StringUtilities.spaceAfter(this.queryExpression.connector()) + "select " + (this.queryExpression.isDistinct() ? "distinct " : "") + this.calculateColumnList() + " from " + this.calculateTableName(this.queryExpression.table()) + StringUtilities.spaceBefore(this.queryExpression.joinModel().map(this::renderJoin));
    }

    private String calculateColumnList() {
        return this.queryExpression.mapColumns(this::applyTableAndColumnAlias).collect(Collectors.joining(", "));
    }

    private String calculateTableName(SqlTable table) {
        return this.queryExpression.calculateTableNameIncludingAlias(table);
    }

    private String applyTableAndColumnAlias(BasicColumn selectListItem) {
        return selectListItem.renderWithTableAndColumnAlias(this.queryExpression.tableAliasCalculator());
    }

    private String renderJoin(JoinModel joinModel) {
        return JoinRenderer.withJoinModel(joinModel).withQueryExpression(this.queryExpression).build().render();
    }

    private Optional<WhereClauseProvider> renderWhereClause(WhereModel whereModel) {
        return WhereRenderer.withWhereModel(whereModel).withRenderingStrategy(this.renderingStrategy).withTableAliasCalculator(this.queryExpression.tableAliasCalculator()).withSequence(this.sequence).build().render();
    }

    private String renderGroupBy(GroupByModel groupByModel) {
        return groupByModel.mapColumns(this::applyTableAlias).collect(CustomCollectors.joining(", ", "group by ", ""));
    }

    private String applyTableAlias(BasicColumn column) {
        return column.renderWithTableAlias(this.queryExpression.tableAliasCalculator());
    }

    public static Builder withQueryExpression(QueryExpressionModel model) {
        return new Builder().withQueryExpression(model);
    }

    public static class Builder {
        private QueryExpressionModel queryExpression;
        private RenderingStrategy renderingStrategy;
        private AtomicInteger sequence;

        public Builder withQueryExpression(QueryExpressionModel queryExpression) {
            this.queryExpression = queryExpression;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder withSequence(AtomicInteger sequence) {
            this.sequence = sequence;
            return this;
        }

        public QueryExpressionRenderer build() {
            return new QueryExpressionRenderer(this);
        }
    }
}

