/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.select.AbstractQueryExpressionDSL;
import org.mybatis.dynamic.sql.select.GroupByModel;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.SelectDSL;
import org.mybatis.dynamic.sql.select.join.JoinCondition;
import org.mybatis.dynamic.sql.select.join.JoinCriterion;
import org.mybatis.dynamic.sql.select.join.JoinSpecification;
import org.mybatis.dynamic.sql.select.join.JoinType;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.where.AbstractWhereDSL;
import org.mybatis.dynamic.sql.where.WhereApplier;
import org.mybatis.dynamic.sql.where.WhereModel;

public class QueryExpressionDSL<R>
extends AbstractQueryExpressionDSL<QueryExpressionDSL<R>, R>
implements Buildable<R> {
    private final String connector;
    private final SelectDSL<R> selectDSL;
    private final boolean isDistinct;
    private final List<BasicColumn> selectList;
    private final QueryExpressionWhereBuilder whereBuilder = new QueryExpressionWhereBuilder();
    private GroupByModel groupByModel;

    QueryExpressionDSL(FromGatherer<R> fromGatherer) {
        super(((FromGatherer)fromGatherer).table);
        this.connector = ((FromGatherer)fromGatherer).connector;
        this.selectList = ((FromGatherer)fromGatherer).selectList;
        this.isDistinct = ((FromGatherer)fromGatherer).isDistinct;
        this.selectDSL = Objects.requireNonNull(((FromGatherer)fromGatherer).selectDSL);
    }

    QueryExpressionDSL(FromGatherer<R> fromGatherer, String tableAlias) {
        this(fromGatherer);
        this.tableAliases.put(((FromGatherer)fromGatherer).table, tableAlias);
    }

    public QueryExpressionWhereBuilder where() {
        return this.whereBuilder;
    }

    public <T> QueryExpressionWhereBuilder where(BindableColumn<T> column, VisitableCondition<T> condition, SqlCriterion<?> ... subCriteria) {
        this.whereBuilder.where(column, condition, subCriteria);
        return this.whereBuilder;
    }

    public QueryExpressionWhereBuilder applyWhere(WhereApplier whereApplier) {
        return (QueryExpressionWhereBuilder)this.whereBuilder.applyWhere(whereApplier);
    }

    @Override
    @NotNull
    public R build() {
        return this.selectDSL.build();
    }

    public JoinSpecificationStarter join(SqlTable joinTable) {
        return new JoinSpecificationStarter(joinTable, JoinType.INNER);
    }

    public JoinSpecificationStarter join(SqlTable joinTable, String tableAlias) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.join(joinTable);
    }

    public JoinSpecificationStarter leftJoin(SqlTable joinTable) {
        return new JoinSpecificationStarter(joinTable, JoinType.LEFT);
    }

    public JoinSpecificationStarter leftJoin(SqlTable joinTable, String tableAlias) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.leftJoin(joinTable);
    }

    public JoinSpecificationStarter rightJoin(SqlTable joinTable) {
        return new JoinSpecificationStarter(joinTable, JoinType.RIGHT);
    }

    public JoinSpecificationStarter rightJoin(SqlTable joinTable, String tableAlias) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.rightJoin(joinTable);
    }

    public JoinSpecificationStarter fullJoin(SqlTable joinTable) {
        return new JoinSpecificationStarter(joinTable, JoinType.FULL);
    }

    public JoinSpecificationStarter fullJoin(SqlTable joinTable, String tableAlias) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.fullJoin(joinTable);
    }

    public GroupByFinisher groupBy(BasicColumn ... columns) {
        return this.groupBy(Arrays.asList(columns));
    }

    public GroupByFinisher groupBy(Collection<BasicColumn> columns) {
        this.groupByModel = GroupByModel.of(columns);
        return new GroupByFinisher();
    }

    public SelectDSL<R> orderBy(SortSpecification ... columns) {
        return this.orderBy(Arrays.asList(columns));
    }

    public SelectDSL<R> orderBy(Collection<SortSpecification> columns) {
        this.selectDSL.orderBy(columns);
        return this.selectDSL;
    }

    public UnionBuilder union() {
        return new UnionBuilder("union");
    }

    public UnionBuilder unionAll() {
        return new UnionBuilder("union all");
    }

    protected QueryExpressionModel buildModel() {
        return QueryExpressionModel.withSelectList(this.selectList).withConnector(this.connector).withTable(this.table()).isDistinct(this.isDistinct).withTableAliases(this.tableAliases).withWhereModel(this.whereBuilder.buildWhereModel()).withJoinModel(this.buildJoinModel().orElse(null)).withGroupByModel(this.groupByModel).build();
    }

    public SelectDSL.LimitFinisher limit(long limit) {
        return this.selectDSL.limit(limit);
    }

    public SelectDSL.OffsetFirstFinisher offset(long offset) {
        return this.selectDSL.offset(offset);
    }

    public SelectDSL.FetchFirstFinisher fetchFirst(long fetchFirstRows) {
        return this.selectDSL.fetchFirst(fetchFirstRows);
    }

    @Override
    protected QueryExpressionDSL<R> getThis() {
        return this;
    }

    public class UnionBuilder {
        protected final String connector;

        public UnionBuilder(String connector) {
            this.connector = connector;
        }

        public FromGatherer<R> select(BasicColumn ... selectList) {
            return this.select(Arrays.asList(selectList));
        }

        public FromGatherer<R> select(List<BasicColumn> selectList) {
            return new FromGatherer.Builder().withConnector(this.connector).withSelectList(selectList).withSelectDSL(QueryExpressionDSL.this.selectDSL).build();
        }

        public FromGatherer<R> selectDistinct(BasicColumn ... selectList) {
            return this.selectDistinct(Arrays.asList(selectList));
        }

        public FromGatherer<R> selectDistinct(List<BasicColumn> selectList) {
            return new FromGatherer.Builder().withConnector(this.connector).withSelectList(selectList).withSelectDSL(QueryExpressionDSL.this.selectDSL).isDistinct().build();
        }
    }

    public class GroupByFinisher
    implements Buildable<R> {
        public SelectDSL<R> orderBy(SortSpecification ... columns) {
            return QueryExpressionDSL.this.orderBy(columns);
        }

        @Override
        @NotNull
        public R build() {
            return QueryExpressionDSL.this.build();
        }

        public UnionBuilder union() {
            return QueryExpressionDSL.this.union();
        }

        public UnionBuilder unionAll() {
            return QueryExpressionDSL.this.unionAll();
        }

        public SelectDSL.LimitFinisher limit(long limit) {
            return QueryExpressionDSL.this.limit(limit);
        }

        public SelectDSL.OffsetFirstFinisher offset(long offset) {
            return QueryExpressionDSL.this.offset(offset);
        }

        public SelectDSL.FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            return QueryExpressionDSL.this.fetchFirst(fetchFirstRows);
        }
    }

    public class JoinSpecificationFinisher
    implements Buildable<R> {
        private final JoinSpecification.Builder joinSpecificationBuilder;

        public JoinSpecificationFinisher(SqlTable table, BasicColumn joinColumn, JoinCondition joinCondition, JoinType joinType) {
            JoinCriterion joinCriterion = new JoinCriterion.Builder().withConnector("on").withJoinColumn(joinColumn).withJoinCondition(joinCondition).build();
            this.joinSpecificationBuilder = JoinSpecification.withJoinTable(table).withJoinType(joinType).withJoinCriterion(joinCriterion);
            QueryExpressionDSL.this.addJoinSpecificationBuilder(this.joinSpecificationBuilder);
        }

        public JoinSpecificationFinisher(SqlTable table, BasicColumn joinColumn, JoinCondition joinCondition, JoinType joinType, JoinCriterion ... andJoinCriteria) {
            JoinCriterion onJoinCriterion2 = new JoinCriterion.Builder().withConnector("on").withJoinColumn(joinColumn).withJoinCondition(joinCondition).build();
            this.joinSpecificationBuilder = JoinSpecification.withJoinTable(table).withJoinType(joinType).withJoinCriterion(onJoinCriterion2).withJoinCriteria(Arrays.asList(andJoinCriteria));
            QueryExpressionDSL.this.addJoinSpecificationBuilder(this.joinSpecificationBuilder);
        }

        @Override
        @NotNull
        public R build() {
            return QueryExpressionDSL.this.build();
        }

        public QueryExpressionWhereBuilder where() {
            return QueryExpressionDSL.this.where();
        }

        public <T> QueryExpressionWhereBuilder where(BindableColumn<T> column, VisitableCondition<T> condition, SqlCriterion<?> ... subCriteria) {
            return QueryExpressionDSL.this.where(column, condition, subCriteria);
        }

        public QueryExpressionWhereBuilder applyWhere(WhereApplier whereApplier) {
            return QueryExpressionDSL.this.applyWhere(whereApplier);
        }

        public JoinSpecificationFinisher and(BasicColumn joinColumn, JoinCondition joinCondition) {
            JoinCriterion joinCriterion = new JoinCriterion.Builder().withConnector("and").withJoinColumn(joinColumn).withJoinCondition(joinCondition).build();
            this.joinSpecificationBuilder.withJoinCriterion(joinCriterion);
            return this;
        }

        public JoinSpecificationStarter join(SqlTable joinTable) {
            return QueryExpressionDSL.this.join(joinTable);
        }

        public JoinSpecificationStarter join(SqlTable joinTable, String tableAlias) {
            return QueryExpressionDSL.this.join(joinTable, tableAlias);
        }

        public JoinSpecificationStarter leftJoin(SqlTable joinTable) {
            return QueryExpressionDSL.this.leftJoin(joinTable);
        }

        public JoinSpecificationStarter leftJoin(SqlTable joinTable, String tableAlias) {
            return QueryExpressionDSL.this.leftJoin(joinTable, tableAlias);
        }

        public JoinSpecificationStarter rightJoin(SqlTable joinTable) {
            return QueryExpressionDSL.this.rightJoin(joinTable);
        }

        public JoinSpecificationStarter rightJoin(SqlTable joinTable, String tableAlias) {
            return QueryExpressionDSL.this.rightJoin(joinTable, tableAlias);
        }

        public JoinSpecificationStarter fullJoin(SqlTable joinTable) {
            return QueryExpressionDSL.this.fullJoin(joinTable);
        }

        public JoinSpecificationStarter fullJoin(SqlTable joinTable, String tableAlias) {
            return QueryExpressionDSL.this.fullJoin(joinTable, tableAlias);
        }

        public GroupByFinisher groupBy(BasicColumn ... columns) {
            return QueryExpressionDSL.this.groupBy(columns);
        }

        public UnionBuilder union() {
            return QueryExpressionDSL.this.union();
        }

        public UnionBuilder unionAll() {
            return QueryExpressionDSL.this.unionAll();
        }

        public SelectDSL<R> orderBy(SortSpecification ... columns) {
            return QueryExpressionDSL.this.orderBy(columns);
        }

        public SelectDSL.LimitFinisher limit(long limit) {
            return QueryExpressionDSL.this.limit(limit);
        }

        public SelectDSL.OffsetFirstFinisher offset(long offset) {
            return QueryExpressionDSL.this.offset(offset);
        }

        public SelectDSL.FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            return QueryExpressionDSL.this.fetchFirst(fetchFirstRows);
        }
    }

    public class JoinSpecificationStarter {
        private final SqlTable joinTable;
        private final JoinType joinType;

        public JoinSpecificationStarter(SqlTable joinTable, JoinType joinType) {
            this.joinTable = joinTable;
            this.joinType = joinType;
        }

        public JoinSpecificationFinisher on(BasicColumn joinColumn, JoinCondition joinCondition) {
            return new JoinSpecificationFinisher(this.joinTable, joinColumn, joinCondition, this.joinType);
        }

        public JoinSpecificationFinisher on(BasicColumn joinColumn, JoinCondition onJoinCondition, JoinCriterion ... andJoinCriteria) {
            return new JoinSpecificationFinisher(this.joinTable, joinColumn, onJoinCondition, this.joinType, andJoinCriteria);
        }
    }

    public class QueryExpressionWhereBuilder
    extends AbstractWhereDSL<QueryExpressionWhereBuilder>
    implements Buildable<R> {
        private QueryExpressionWhereBuilder() {
        }

        public UnionBuilder union() {
            return QueryExpressionDSL.this.union();
        }

        public UnionBuilder unionAll() {
            return QueryExpressionDSL.this.unionAll();
        }

        public SelectDSL<R> orderBy(SortSpecification ... columns) {
            return QueryExpressionDSL.this.orderBy(columns);
        }

        public GroupByFinisher groupBy(BasicColumn ... columns) {
            return QueryExpressionDSL.this.groupBy(columns);
        }

        public SelectDSL.LimitFinisher limit(long limit) {
            return QueryExpressionDSL.this.limit(limit);
        }

        public SelectDSL.OffsetFirstFinisher offset(long offset) {
            return QueryExpressionDSL.this.offset(offset);
        }

        public SelectDSL.FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            return QueryExpressionDSL.this.fetchFirst(fetchFirstRows);
        }

        @Override
        @NotNull
        public R build() {
            return QueryExpressionDSL.this.build();
        }

        @Override
        protected QueryExpressionWhereBuilder getThis() {
            return this;
        }

        @Override
        protected WhereModel buildWhereModel() {
            return super.internalBuild();
        }
    }

    public static class FromGatherer<R> {
        private final String connector;
        private final List<BasicColumn> selectList;
        private final SelectDSL<R> selectDSL;
        private final boolean isDistinct;
        private SqlTable table;

        public FromGatherer(Builder<R> builder) {
            this.connector = ((Builder)builder).connector;
            this.selectList = Objects.requireNonNull(((Builder)builder).selectList);
            this.selectDSL = Objects.requireNonNull(((Builder)builder).selectDSL);
            this.isDistinct = ((Builder)builder).isDistinct;
        }

        public QueryExpressionDSL<R> from(SqlTable table) {
            this.table = table;
            return this.selectDSL.newQueryExpression(this);
        }

        public QueryExpressionDSL<R> from(SqlTable table, String tableAlias) {
            this.table = table;
            return this.selectDSL.newQueryExpression(this, tableAlias);
        }

        public static class Builder<R> {
            private String connector;
            private final List<BasicColumn> selectList = new ArrayList<BasicColumn>();
            private SelectDSL<R> selectDSL;
            private boolean isDistinct;

            public Builder<R> withConnector(String connector) {
                this.connector = connector;
                return this;
            }

            public Builder<R> withSelectList(Collection<BasicColumn> selectList) {
                this.selectList.addAll(selectList);
                return this;
            }

            public Builder<R> withSelectDSL(SelectDSL<R> selectDSL) {
                this.selectDSL = selectDSL;
                return this;
            }

            public Builder<R> isDistinct() {
                this.isDistinct = true;
                return this;
            }

            public FromGatherer<R> build() {
                return new FromGatherer(this);
            }
        }
    }
}

