/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.select.join.JoinCriterion;
import org.mybatis.dynamic.sql.select.join.JoinModel;
import org.mybatis.dynamic.sql.select.join.JoinSpecification;
import org.mybatis.dynamic.sql.select.join.JoinType;
import org.mybatis.dynamic.sql.util.Buildable;

public abstract class AbstractQueryExpressionDSL<T extends AbstractQueryExpressionDSL<T, R>, R>
implements Buildable<R> {
    private final List<JoinSpecification.Builder> joinSpecificationBuilders = new ArrayList<JoinSpecification.Builder>();
    protected final Map<SqlTable, String> tableAliases = new HashMap<SqlTable, String>();
    private final SqlTable table;

    protected AbstractQueryExpressionDSL(SqlTable table) {
        this.table = Objects.requireNonNull(table);
    }

    public SqlTable table() {
        return this.table;
    }

    public T join(SqlTable joinTable, JoinCriterion onJoinCriterion2, JoinCriterion ... andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion2, JoinType.INNER, Arrays.asList(andJoinCriteria));
        return this.getThis();
    }

    public T join(SqlTable joinTable, String tableAlias, JoinCriterion onJoinCriterion2, JoinCriterion ... andJoinCriteria) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.join(joinTable, onJoinCriterion2, andJoinCriteria);
    }

    public T join(SqlTable joinTable, JoinCriterion onJoinCriterion2, List<JoinCriterion> andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion2, JoinType.INNER, andJoinCriteria);
        return this.getThis();
    }

    public T join(SqlTable joinTable, String tableAlias, JoinCriterion onJoinCriterion2, List<JoinCriterion> andJoinCriteria) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.join(joinTable, onJoinCriterion2, andJoinCriteria);
    }

    public T leftJoin(SqlTable joinTable, JoinCriterion onJoinCriterion2, JoinCriterion ... andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion2, JoinType.LEFT, Arrays.asList(andJoinCriteria));
        return this.getThis();
    }

    public T leftJoin(SqlTable joinTable, String tableAlias, JoinCriterion onJoinCriterion2, JoinCriterion ... andJoinCriteria) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.leftJoin(joinTable, onJoinCriterion2, andJoinCriteria);
    }

    public T leftJoin(SqlTable joinTable, JoinCriterion onJoinCriterion2, List<JoinCriterion> andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion2, JoinType.LEFT, andJoinCriteria);
        return this.getThis();
    }

    public T leftJoin(SqlTable joinTable, String tableAlias, JoinCriterion onJoinCriterion2, List<JoinCriterion> andJoinCriteria) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.leftJoin(joinTable, onJoinCriterion2, andJoinCriteria);
    }

    public T rightJoin(SqlTable joinTable, JoinCriterion onJoinCriterion2, JoinCriterion ... andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion2, JoinType.RIGHT, Arrays.asList(andJoinCriteria));
        return this.getThis();
    }

    public T rightJoin(SqlTable joinTable, String tableAlias, JoinCriterion onJoinCriterion2, JoinCriterion ... andJoinCriteria) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.rightJoin(joinTable, onJoinCriterion2, andJoinCriteria);
    }

    public T rightJoin(SqlTable joinTable, JoinCriterion onJoinCriterion2, List<JoinCriterion> andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion2, JoinType.RIGHT, andJoinCriteria);
        return this.getThis();
    }

    public T rightJoin(SqlTable joinTable, String tableAlias, JoinCriterion onJoinCriterion2, List<JoinCriterion> andJoinCriteria) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.rightJoin(joinTable, onJoinCriterion2, andJoinCriteria);
    }

    public T fullJoin(SqlTable joinTable, JoinCriterion onJoinCriterion2, JoinCriterion ... andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion2, JoinType.FULL, Arrays.asList(andJoinCriteria));
        return this.getThis();
    }

    public T fullJoin(SqlTable joinTable, String tableAlias, JoinCriterion onJoinCriterion2, JoinCriterion ... andJoinCriteria) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.fullJoin(joinTable, onJoinCriterion2, andJoinCriteria);
    }

    public T fullJoin(SqlTable joinTable, JoinCriterion onJoinCriterion2, List<JoinCriterion> andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion2, JoinType.FULL, andJoinCriteria);
        return this.getThis();
    }

    public T fullJoin(SqlTable joinTable, String tableAlias, JoinCriterion onJoinCriterion2, List<JoinCriterion> andJoinCriteria) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.fullJoin(joinTable, onJoinCriterion2, andJoinCriteria);
    }

    private void addJoinSpecificationBuilder(SqlTable joinTable, JoinCriterion onJoinCriterion2, JoinType joinType, List<JoinCriterion> andJoinCriteria) {
        this.joinSpecificationBuilders.add(new JoinSpecification.Builder().withJoinTable(joinTable).withJoinType(joinType).withJoinCriterion(onJoinCriterion2).withJoinCriteria(andJoinCriteria));
    }

    protected void addJoinSpecificationBuilder(JoinSpecification.Builder builder) {
        this.joinSpecificationBuilders.add(builder);
    }

    protected Optional<JoinModel> buildJoinModel() {
        if (this.joinSpecificationBuilders.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(JoinModel.of(this.joinSpecificationBuilders.stream().map(JoinSpecification.Builder::build).collect(Collectors.toList())));
    }

    protected abstract T getThis();
}

