/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.insert.InsertModel;
import org.mybatis.dynamic.sql.insert.render.DefaultInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.FieldAndValue;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.ValuePhraseVisitor;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class InsertRenderer<T> {
    private final InsertModel<T> model;
    private final RenderingStrategy renderingStrategy;

    private InsertRenderer(Builder<T> builder) {
        this.model = Objects.requireNonNull(((Builder)builder).model);
        this.renderingStrategy = Objects.requireNonNull(((Builder)builder).renderingStrategy);
    }

    public InsertStatementProvider<T> render() {
        ValuePhraseVisitor visitor = new ValuePhraseVisitor(this.renderingStrategy);
        List<Optional<FieldAndValue>> fieldsAndValues = this.model.mapColumnMappings(m -> m.accept(visitor)).collect(Collectors.toList());
        return DefaultInsertStatementProvider.withRecord(this.model.record()).withInsertStatement(this.calculateInsertStatement(fieldsAndValues)).build();
    }

    private String calculateInsertStatement(List<Optional<FieldAndValue>> fieldsAndValues) {
        return "insert into" + StringUtilities.spaceBefore(this.model.table().tableNameAtRuntime()) + StringUtilities.spaceBefore(this.calculateColumnsPhrase(fieldsAndValues)) + StringUtilities.spaceBefore(this.calculateValuesPhrase(fieldsAndValues));
    }

    private String calculateColumnsPhrase(List<Optional<FieldAndValue>> fieldsAndValues) {
        return fieldsAndValues.stream().filter(Optional::isPresent).map(Optional::get).map(FieldAndValue::fieldName).collect(Collectors.joining(", ", "(", ")"));
    }

    private String calculateValuesPhrase(List<Optional<FieldAndValue>> fieldsAndValues) {
        return fieldsAndValues.stream().filter(Optional::isPresent).map(Optional::get).map(FieldAndValue::valuePhrase).collect(Collectors.joining(", ", "values (", ")"));
    }

    public static <T> Builder<T> withInsertModel(InsertModel<T> model) {
        return new Builder<T>().withInsertModel(model);
    }

    public static class Builder<T> {
        private InsertModel<T> model;
        private RenderingStrategy renderingStrategy;

        public Builder<T> withInsertModel(InsertModel<T> model) {
            this.model = model;
            return this;
        }

        public Builder<T> withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public InsertRenderer<T> build() {
            return new InsertRenderer(this);
        }
    }
}

