/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.insert.GeneralInsertModel;
import org.mybatis.dynamic.sql.insert.render.DefaultGeneralInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.FieldAndValueAndParameters;
import org.mybatis.dynamic.sql.insert.render.GeneralInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.GeneralInsertValuePhraseVisitor;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class GeneralInsertRenderer {
    private final GeneralInsertModel model;
    private final RenderingStrategy renderingStrategy;

    private GeneralInsertRenderer(Builder builder) {
        this.model = Objects.requireNonNull(builder.model);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
    }

    public GeneralInsertStatementProvider render() {
        GeneralInsertValuePhraseVisitor visitor = new GeneralInsertValuePhraseVisitor(this.renderingStrategy);
        List<Optional<FieldAndValueAndParameters>> fieldsAndValues = this.model.mapColumnMappings(m -> m.accept(visitor)).collect(Collectors.toList());
        return DefaultGeneralInsertStatementProvider.withInsertStatement(this.calculateInsertStatement(fieldsAndValues)).withParameters(this.calculateParameters(fieldsAndValues)).build();
    }

    private String calculateInsertStatement(List<Optional<FieldAndValueAndParameters>> fieldsAndValues) {
        return "insert into" + StringUtilities.spaceBefore(this.model.table().tableNameAtRuntime()) + StringUtilities.spaceBefore(this.calculateColumnsPhrase(fieldsAndValues)) + StringUtilities.spaceBefore(this.calculateValuesPhrase(fieldsAndValues));
    }

    private String calculateColumnsPhrase(List<Optional<FieldAndValueAndParameters>> fieldsAndValues) {
        return fieldsAndValues.stream().filter(Optional::isPresent).map(Optional::get).map(FieldAndValueAndParameters::fieldName).collect(Collectors.joining(", ", "(", ")"));
    }

    private String calculateValuesPhrase(List<Optional<FieldAndValueAndParameters>> fieldsAndValues) {
        return fieldsAndValues.stream().filter(Optional::isPresent).map(Optional::get).map(FieldAndValueAndParameters::valuePhrase).collect(Collectors.joining(", ", "values (", ")"));
    }

    private Map<String, Object> calculateParameters(List<Optional<FieldAndValueAndParameters>> fieldsAndValues) {
        return fieldsAndValues.stream().filter(Optional::isPresent).map(Optional::get).map(FieldAndValueAndParameters::parameters).collect(HashMap::new, HashMap::putAll, HashMap::putAll);
    }

    public static Builder withInsertModel(GeneralInsertModel model) {
        return new Builder().withInsertModel(model);
    }

    public static class Builder {
        private GeneralInsertModel model;
        private RenderingStrategy renderingStrategy;

        public Builder withInsertModel(GeneralInsertModel model) {
            this.model = model;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public GeneralInsertRenderer build() {
            return new GeneralInsertRenderer(this);
        }
    }
}

