/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.insert.render.DefaultInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;

public class BatchInsert<T> {
    private final String insertStatement;
    private final List<T> records;

    private BatchInsert(Builder<T> builder) {
        this.insertStatement = Objects.requireNonNull(((Builder)builder).insertStatement);
        this.records = Collections.unmodifiableList(Objects.requireNonNull(((Builder)builder).records));
    }

    public List<InsertStatementProvider<T>> insertStatements() {
        return this.records.stream().map(this::toInsertStatement).collect(Collectors.toList());
    }

    private InsertStatementProvider<T> toInsertStatement(T record) {
        return DefaultInsertStatementProvider.withRecord(record).withInsertStatement(this.insertStatement).build();
    }

    public String getInsertStatementSQL() {
        return this.insertStatement;
    }

    public List<T> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    public static <T> Builder<T> withRecords(List<T> records) {
        return new Builder<T>().withRecords(records);
    }

    public static class Builder<T> {
        private String insertStatement;
        private final List<T> records = new ArrayList<T>();

        public Builder<T> withInsertStatement(String insertStatement) {
            this.insertStatement = insertStatement;
            return this;
        }

        public Builder<T> withRecords(List<T> records) {
            this.records.addAll(records);
            return this;
        }

        public BatchInsert<T> build() {
            return new BatchInsert(this);
        }
    }
}

