/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.insert.render.FieldAndValue;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.MultiRowInsertMappingVisitor;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.PropertyMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;

public abstract class AbstractMultiRowValuePhraseVisitor
extends MultiRowInsertMappingVisitor<FieldAndValue> {
    protected final RenderingStrategy renderingStrategy;
    protected final String prefix;

    public AbstractMultiRowValuePhraseVisitor(RenderingStrategy renderingStrategy, String prefix) {
        this.renderingStrategy = renderingStrategy;
        this.prefix = prefix;
    }

    @Override
    public FieldAndValue visit(NullMapping mapping) {
        return FieldAndValue.withFieldName(mapping.columnName()).withValuePhrase("null").build();
    }

    @Override
    public FieldAndValue visit(ConstantMapping mapping) {
        return FieldAndValue.withFieldName(mapping.columnName()).withValuePhrase(mapping.constant()).build();
    }

    @Override
    public FieldAndValue visit(StringConstantMapping mapping) {
        return FieldAndValue.withFieldName(mapping.columnName()).withValuePhrase("'" + mapping.constant() + "'").build();
    }

    @Override
    public FieldAndValue visit(PropertyMapping mapping) {
        return FieldAndValue.withFieldName(mapping.columnName()).withValuePhrase(mapping.mapColumn(c -> this.calculateJdbcPlaceholder((SqlColumn<?>)c, mapping.property()))).build();
    }

    abstract String calculateJdbcPlaceholder(SqlColumn<?> var1, String var2);
}

