/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.insert.render.InsertRenderer;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;

public class InsertModel<T> {
    private final SqlTable table;
    private final T record;
    private final List<AbstractColumnMapping> columnMappings;

    private InsertModel(Builder<T> builder) {
        this.table = Objects.requireNonNull(((Builder)builder).table);
        this.record = Objects.requireNonNull(((Builder)builder).record);
        this.columnMappings = Objects.requireNonNull(((Builder)builder).columnMappings);
    }

    public <R> Stream<R> mapColumnMappings(Function<AbstractColumnMapping, R> mapper) {
        return this.columnMappings.stream().map(mapper);
    }

    public T record() {
        return this.record;
    }

    public SqlTable table() {
        return this.table;
    }

    @NotNull
    public InsertStatementProvider<T> render(RenderingStrategy renderingStrategy) {
        return InsertRenderer.withInsertModel(this).withRenderingStrategy(renderingStrategy).build().render();
    }

    public static <T> Builder<T> withRecord(T record) {
        return new Builder<T>().withRecord(record);
    }

    public static class Builder<T> {
        private SqlTable table;
        private T record;
        private final List<AbstractColumnMapping> columnMappings = new ArrayList<AbstractColumnMapping>();

        public Builder<T> withTable(SqlTable table) {
            this.table = table;
            return this;
        }

        public Builder<T> withRecord(T record) {
            this.record = record;
            return this;
        }

        public Builder<T> withColumnMappings(List<AbstractColumnMapping> columnMappings) {
            this.columnMappings.addAll(columnMappings);
            return this;
        }

        public InsertModel<T> build() {
            return new InsertModel(this);
        }
    }
}

