/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.VisitableCondition;

public class SqlCriterion<T> {
    private final BindableColumn<T> column;
    private final VisitableCondition<T> condition;
    private final String connector;
    private final List<SqlCriterion<?>> subCriteria;

    private SqlCriterion(Builder<T> builder) {
        this.connector = ((Builder)builder).connector;
        this.column = Objects.requireNonNull(((Builder)builder).column);
        this.condition = Objects.requireNonNull(((Builder)builder).condition);
        this.subCriteria = Objects.requireNonNull(((Builder)builder).subCriteria);
    }

    public Optional<String> connector() {
        return Optional.ofNullable(this.connector);
    }

    public BindableColumn<T> column() {
        return this.column;
    }

    public VisitableCondition<T> condition() {
        return this.condition;
    }

    public <R> Stream<R> mapSubCriteria(Function<SqlCriterion<?>, R> mapper) {
        return this.subCriteria.stream().map(mapper);
    }

    public static <T> Builder<T> withColumn(BindableColumn<T> column) {
        return new Builder<T>().withColumn(column);
    }

    public static class Builder<T> {
        private String connector;
        private BindableColumn<T> column;
        private VisitableCondition<T> condition;
        private final List<SqlCriterion<?>> subCriteria = new ArrayList();

        public Builder<T> withConnector(String connector) {
            this.connector = connector;
            return this;
        }

        public Builder<T> withColumn(BindableColumn<T> column) {
            this.column = column;
            return this;
        }

        public Builder<T> withCondition(VisitableCondition<T> condition) {
            this.condition = condition;
            return this;
        }

        public Builder<T> withSubCriteria(List<SqlCriterion<?>> subCriteria) {
            this.subCriteria.addAll(subCriteria);
            return this;
        }

        public SqlCriterion<T> build() {
            return new SqlCriterion(this);
        }
    }
}

