/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.Constant;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.StringConstant;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.delete.DeleteDSL;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.insert.BatchInsertDSL;
import org.mybatis.dynamic.sql.insert.GeneralInsertDSL;
import org.mybatis.dynamic.sql.insert.InsertDSL;
import org.mybatis.dynamic.sql.insert.InsertSelectDSL;
import org.mybatis.dynamic.sql.insert.MultiRowInsertDSL;
import org.mybatis.dynamic.sql.select.CountDSL;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.SimpleSortSpecification;
import org.mybatis.dynamic.sql.select.aggregate.Avg;
import org.mybatis.dynamic.sql.select.aggregate.Count;
import org.mybatis.dynamic.sql.select.aggregate.CountAll;
import org.mybatis.dynamic.sql.select.aggregate.CountDistinct;
import org.mybatis.dynamic.sql.select.aggregate.Max;
import org.mybatis.dynamic.sql.select.aggregate.Min;
import org.mybatis.dynamic.sql.select.aggregate.Sum;
import org.mybatis.dynamic.sql.select.function.Add;
import org.mybatis.dynamic.sql.select.function.Concatenate;
import org.mybatis.dynamic.sql.select.function.Divide;
import org.mybatis.dynamic.sql.select.function.Lower;
import org.mybatis.dynamic.sql.select.function.Multiply;
import org.mybatis.dynamic.sql.select.function.OperatorFunction;
import org.mybatis.dynamic.sql.select.function.Substring;
import org.mybatis.dynamic.sql.select.function.Subtract;
import org.mybatis.dynamic.sql.select.function.Upper;
import org.mybatis.dynamic.sql.select.join.EqualTo;
import org.mybatis.dynamic.sql.select.join.JoinCondition;
import org.mybatis.dynamic.sql.select.join.JoinCriterion;
import org.mybatis.dynamic.sql.update.UpdateDSL;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.where.WhereDSL;
import org.mybatis.dynamic.sql.where.condition.IsBetween;
import org.mybatis.dynamic.sql.where.condition.IsBetweenWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsEqualTo;
import org.mybatis.dynamic.sql.where.condition.IsEqualToColumn;
import org.mybatis.dynamic.sql.where.condition.IsEqualToWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsEqualToWithSubselect;
import org.mybatis.dynamic.sql.where.condition.IsGreaterThan;
import org.mybatis.dynamic.sql.where.condition.IsGreaterThanColumn;
import org.mybatis.dynamic.sql.where.condition.IsGreaterThanOrEqualTo;
import org.mybatis.dynamic.sql.where.condition.IsGreaterThanOrEqualToColumn;
import org.mybatis.dynamic.sql.where.condition.IsGreaterThanOrEqualToWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsGreaterThanOrEqualToWithSubselect;
import org.mybatis.dynamic.sql.where.condition.IsGreaterThanWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsGreaterThanWithSubselect;
import org.mybatis.dynamic.sql.where.condition.IsIn;
import org.mybatis.dynamic.sql.where.condition.IsInCaseInsensitive;
import org.mybatis.dynamic.sql.where.condition.IsInCaseInsensitiveWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsInWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsInWithSubselect;
import org.mybatis.dynamic.sql.where.condition.IsLessThan;
import org.mybatis.dynamic.sql.where.condition.IsLessThanColumn;
import org.mybatis.dynamic.sql.where.condition.IsLessThanOrEqualTo;
import org.mybatis.dynamic.sql.where.condition.IsLessThanOrEqualToColumn;
import org.mybatis.dynamic.sql.where.condition.IsLessThanOrEqualToWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsLessThanOrEqualToWithSubselect;
import org.mybatis.dynamic.sql.where.condition.IsLessThanWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsLessThanWithSubselect;
import org.mybatis.dynamic.sql.where.condition.IsLike;
import org.mybatis.dynamic.sql.where.condition.IsLikeCaseInsensitive;
import org.mybatis.dynamic.sql.where.condition.IsLikeCaseInsensitiveWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsLikeWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsNotBetween;
import org.mybatis.dynamic.sql.where.condition.IsNotBetweenWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsNotEqualTo;
import org.mybatis.dynamic.sql.where.condition.IsNotEqualToColumn;
import org.mybatis.dynamic.sql.where.condition.IsNotEqualToWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsNotEqualToWithSubselect;
import org.mybatis.dynamic.sql.where.condition.IsNotIn;
import org.mybatis.dynamic.sql.where.condition.IsNotInCaseInsensitive;
import org.mybatis.dynamic.sql.where.condition.IsNotInCaseInsensitiveWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsNotInWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsNotInWithSubselect;
import org.mybatis.dynamic.sql.where.condition.IsNotLike;
import org.mybatis.dynamic.sql.where.condition.IsNotLikeCaseInsensitive;
import org.mybatis.dynamic.sql.where.condition.IsNotLikeCaseInsensitiveWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsNotLikeWhenPresent;
import org.mybatis.dynamic.sql.where.condition.IsNotNull;
import org.mybatis.dynamic.sql.where.condition.IsNull;

public interface SqlBuilder {
    public static CountDSL.FromGatherer<SelectModel> countDistinctColumn(BasicColumn column) {
        return CountDSL.countDistinct(column);
    }

    public static CountDSL.FromGatherer<SelectModel> countColumn(BasicColumn column) {
        return CountDSL.count(column);
    }

    public static CountDSL<SelectModel> countFrom(SqlTable table) {
        return CountDSL.countFrom(table);
    }

    public static DeleteDSL<DeleteModel> deleteFrom(SqlTable table) {
        return DeleteDSL.deleteFrom(table);
    }

    public static <T> InsertDSL.IntoGatherer<T> insert(T record) {
        return InsertDSL.insert(record);
    }

    @Deprecated
    @SafeVarargs
    public static <T> BatchInsertDSL.IntoGatherer<T> insert(T ... records) {
        return SqlBuilder.insertBatch(records);
    }

    @Deprecated
    public static <T> BatchInsertDSL.IntoGatherer<T> insert(Collection<T> records) {
        return SqlBuilder.insertBatch(records);
    }

    @SafeVarargs
    public static <T> BatchInsertDSL.IntoGatherer<T> insertBatch(T ... records) {
        return BatchInsertDSL.insert(records);
    }

    public static <T> BatchInsertDSL.IntoGatherer<T> insertBatch(Collection<T> records) {
        return BatchInsertDSL.insert(records);
    }

    @SafeVarargs
    public static <T> MultiRowInsertDSL.IntoGatherer<T> insertMultiple(T ... records) {
        return MultiRowInsertDSL.insert(records);
    }

    public static <T> MultiRowInsertDSL.IntoGatherer<T> insertMultiple(Collection<T> records) {
        return MultiRowInsertDSL.insert(records);
    }

    public static InsertIntoNextStep insertInto(SqlTable table) {
        return new InsertIntoNextStep(table);
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> select(BasicColumn ... selectList) {
        return SelectDSL.select(selectList);
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> select(Collection<BasicColumn> selectList) {
        return SelectDSL.select(selectList);
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> selectDistinct(BasicColumn ... selectList) {
        return SelectDSL.selectDistinct(selectList);
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> selectDistinct(Collection<BasicColumn> selectList) {
        return SelectDSL.selectDistinct(selectList);
    }

    public static UpdateDSL<UpdateModel> update(SqlTable table) {
        return UpdateDSL.update(table);
    }

    public static WhereDSL where() {
        return WhereDSL.where();
    }

    public static <T> WhereDSL where(BindableColumn<T> column, VisitableCondition<T> condition) {
        return (WhereDSL)WhereDSL.where().where(column, condition);
    }

    public static <T> WhereDSL where(BindableColumn<T> column, VisitableCondition<T> condition, SqlCriterion<?> ... subCriteria) {
        return (WhereDSL)WhereDSL.where().where(column, condition, subCriteria);
    }

    public static <T> SqlCriterion<T> or(BindableColumn<T> column, VisitableCondition<T> condition) {
        return SqlCriterion.withColumn(column).withConnector("or").withCondition(condition).build();
    }

    public static <T> SqlCriterion<T> or(BindableColumn<T> column, VisitableCondition<T> condition, SqlCriterion<?> ... subCriteria) {
        return SqlCriterion.withColumn(column).withConnector("or").withCondition(condition).withSubCriteria(Arrays.asList(subCriteria)).build();
    }

    public static <T> SqlCriterion<T> and(BindableColumn<T> column, VisitableCondition<T> condition) {
        return SqlCriterion.withColumn(column).withConnector("and").withCondition(condition).build();
    }

    public static <T> SqlCriterion<T> and(BindableColumn<T> column, VisitableCondition<T> condition, SqlCriterion<?> ... subCriteria) {
        return SqlCriterion.withColumn(column).withConnector("and").withCondition(condition).withSubCriteria(Arrays.asList(subCriteria)).build();
    }

    public static JoinCriterion and(BasicColumn joinColumn, JoinCondition joinCondition) {
        return new JoinCriterion.Builder().withConnector("and").withJoinColumn(joinColumn).withJoinCondition(joinCondition).build();
    }

    public static JoinCriterion on(BasicColumn joinColumn, JoinCondition joinCondition) {
        return new JoinCriterion.Builder().withConnector("on").withJoinColumn(joinColumn).withJoinCondition(joinCondition).build();
    }

    public static EqualTo equalTo(BasicColumn column) {
        return new EqualTo(column);
    }

    public static CountAll count() {
        return new CountAll();
    }

    public static Count count(BasicColumn column) {
        return Count.of(column);
    }

    public static CountDistinct countDistinct(BasicColumn column) {
        return CountDistinct.of(column);
    }

    public static <T> Max<T> max(BindableColumn<T> column) {
        return Max.of(column);
    }

    public static <T> Min<T> min(BindableColumn<T> column) {
        return Min.of(column);
    }

    public static <T> Avg<T> avg(BindableColumn<T> column) {
        return Avg.of(column);
    }

    public static <T> Sum<T> sum(BindableColumn<T> column) {
        return Sum.of(column);
    }

    public static <T> Constant<T> constant(String constant) {
        return Constant.of(constant);
    }

    public static StringConstant stringConstant(String constant) {
        return StringConstant.of(constant);
    }

    public static <T extends Number> Add<T> add(BindableColumn<T> firstColumn, BasicColumn secondColumn, BasicColumn ... subsequentColumns) {
        return Add.of(firstColumn, secondColumn, subsequentColumns);
    }

    public static <T extends Number> Divide<T> divide(BindableColumn<T> firstColumn, BasicColumn secondColumn, BasicColumn ... subsequentColumns) {
        return Divide.of(firstColumn, secondColumn, subsequentColumns);
    }

    public static <T extends Number> Multiply<T> multiply(BindableColumn<T> firstColumn, BasicColumn secondColumn, BasicColumn ... subsequentColumns) {
        return Multiply.of(firstColumn, secondColumn, subsequentColumns);
    }

    public static <T extends Number> Subtract<T> subtract(BindableColumn<T> firstColumn, BasicColumn secondColumn, BasicColumn ... subsequentColumns) {
        return Subtract.of(firstColumn, secondColumn, subsequentColumns);
    }

    public static <T> Concatenate<T> concatenate(BindableColumn<T> firstColumn, BasicColumn secondColumn, BasicColumn ... subsequentColumns) {
        return Concatenate.concatenate(firstColumn, secondColumn, subsequentColumns);
    }

    public static <T> OperatorFunction<T> applyOperator(String operator, BindableColumn<T> firstColumn, BasicColumn secondColumn, BasicColumn ... subsequentColumns) {
        return OperatorFunction.of(operator, firstColumn, secondColumn, subsequentColumns);
    }

    public static Lower lower(BindableColumn<String> column) {
        return Lower.of(column);
    }

    public static Substring substring(BindableColumn<String> column, int offset, int length) {
        return Substring.of(column, offset, length);
    }

    public static Upper upper(BindableColumn<String> column) {
        return Upper.of(column);
    }

    public static <T> IsNull<T> isNull() {
        return new IsNull();
    }

    public static <T> IsNotNull<T> isNotNull() {
        return new IsNotNull();
    }

    public static <T> IsEqualTo<T> isEqualTo(T value) {
        return SqlBuilder.isEqualTo(() -> value);
    }

    public static <T> IsEqualTo<T> isEqualTo(Supplier<T> valueSupplier) {
        return IsEqualTo.of(valueSupplier);
    }

    public static <T> IsEqualToWithSubselect<T> isEqualTo(Buildable<SelectModel> selectModelBuilder) {
        return IsEqualToWithSubselect.of(selectModelBuilder);
    }

    public static <T> IsEqualToColumn<T> isEqualTo(BasicColumn column) {
        return IsEqualToColumn.of(column);
    }

    public static <T> IsEqualToWhenPresent<T> isEqualToWhenPresent(T value) {
        return SqlBuilder.isEqualToWhenPresent(() -> value);
    }

    public static <T> IsEqualToWhenPresent<T> isEqualToWhenPresent(Supplier<T> valueSupplier) {
        return IsEqualToWhenPresent.of(valueSupplier);
    }

    public static <T> IsNotEqualTo<T> isNotEqualTo(T value) {
        return SqlBuilder.isNotEqualTo(() -> value);
    }

    public static <T> IsNotEqualTo<T> isNotEqualTo(Supplier<T> valueSupplier) {
        return IsNotEqualTo.of(valueSupplier);
    }

    public static <T> IsNotEqualToWithSubselect<T> isNotEqualTo(Buildable<SelectModel> selectModelBuilder) {
        return IsNotEqualToWithSubselect.of(selectModelBuilder);
    }

    public static <T> IsNotEqualToColumn<T> isNotEqualTo(BasicColumn column) {
        return IsNotEqualToColumn.of(column);
    }

    public static <T> IsNotEqualToWhenPresent<T> isNotEqualToWhenPresent(T value) {
        return SqlBuilder.isNotEqualToWhenPresent(() -> value);
    }

    public static <T> IsNotEqualToWhenPresent<T> isNotEqualToWhenPresent(Supplier<T> valueSupplier) {
        return IsNotEqualToWhenPresent.of(valueSupplier);
    }

    public static <T> IsGreaterThan<T> isGreaterThan(T value) {
        return SqlBuilder.isGreaterThan(() -> value);
    }

    public static <T> IsGreaterThan<T> isGreaterThan(Supplier<T> valueSupplier) {
        return IsGreaterThan.of(valueSupplier);
    }

    public static <T> IsGreaterThanWithSubselect<T> isGreaterThan(Buildable<SelectModel> selectModelBuilder) {
        return IsGreaterThanWithSubselect.of(selectModelBuilder);
    }

    public static <T> IsGreaterThanColumn<T> isGreaterThan(BasicColumn column) {
        return IsGreaterThanColumn.of(column);
    }

    public static <T> IsGreaterThanWhenPresent<T> isGreaterThanWhenPresent(T value) {
        return SqlBuilder.isGreaterThanWhenPresent(() -> value);
    }

    public static <T> IsGreaterThanWhenPresent<T> isGreaterThanWhenPresent(Supplier<T> valueSupplier) {
        return IsGreaterThanWhenPresent.of(valueSupplier);
    }

    public static <T> IsGreaterThanOrEqualTo<T> isGreaterThanOrEqualTo(T value) {
        return SqlBuilder.isGreaterThanOrEqualTo(() -> value);
    }

    public static <T> IsGreaterThanOrEqualTo<T> isGreaterThanOrEqualTo(Supplier<T> valueSupplier) {
        return IsGreaterThanOrEqualTo.of(valueSupplier);
    }

    public static <T> IsGreaterThanOrEqualToWithSubselect<T> isGreaterThanOrEqualTo(Buildable<SelectModel> selectModelBuilder) {
        return IsGreaterThanOrEqualToWithSubselect.of(selectModelBuilder);
    }

    public static <T> IsGreaterThanOrEqualToColumn<T> isGreaterThanOrEqualTo(BasicColumn column) {
        return IsGreaterThanOrEqualToColumn.of(column);
    }

    public static <T> IsGreaterThanOrEqualToWhenPresent<T> isGreaterThanOrEqualToWhenPresent(T value) {
        return SqlBuilder.isGreaterThanOrEqualToWhenPresent(() -> value);
    }

    public static <T> IsGreaterThanOrEqualToWhenPresent<T> isGreaterThanOrEqualToWhenPresent(Supplier<T> valueSupplier) {
        return IsGreaterThanOrEqualToWhenPresent.of(valueSupplier);
    }

    public static <T> IsLessThan<T> isLessThan(T value) {
        return SqlBuilder.isLessThan(() -> value);
    }

    public static <T> IsLessThan<T> isLessThan(Supplier<T> valueSupplier) {
        return IsLessThan.of(valueSupplier);
    }

    public static <T> IsLessThanWithSubselect<T> isLessThan(Buildable<SelectModel> selectModelBuilder) {
        return IsLessThanWithSubselect.of(selectModelBuilder);
    }

    public static <T> IsLessThanColumn<T> isLessThan(BasicColumn column) {
        return IsLessThanColumn.of(column);
    }

    public static <T> IsLessThanWhenPresent<T> isLessThanWhenPresent(T value) {
        return SqlBuilder.isLessThanWhenPresent(() -> value);
    }

    public static <T> IsLessThanWhenPresent<T> isLessThanWhenPresent(Supplier<T> valueSupplier) {
        return IsLessThanWhenPresent.of(valueSupplier);
    }

    public static <T> IsLessThanOrEqualTo<T> isLessThanOrEqualTo(T value) {
        return SqlBuilder.isLessThanOrEqualTo(() -> value);
    }

    public static <T> IsLessThanOrEqualTo<T> isLessThanOrEqualTo(Supplier<T> valueSupplier) {
        return IsLessThanOrEqualTo.of(valueSupplier);
    }

    public static <T> IsLessThanOrEqualToWithSubselect<T> isLessThanOrEqualTo(Buildable<SelectModel> selectModelBuilder) {
        return IsLessThanOrEqualToWithSubselect.of(selectModelBuilder);
    }

    public static <T> IsLessThanOrEqualToColumn<T> isLessThanOrEqualTo(BasicColumn column) {
        return IsLessThanOrEqualToColumn.of(column);
    }

    public static <T> IsLessThanOrEqualToWhenPresent<T> isLessThanOrEqualToWhenPresent(T value) {
        return SqlBuilder.isLessThanOrEqualToWhenPresent(() -> value);
    }

    public static <T> IsLessThanOrEqualToWhenPresent<T> isLessThanOrEqualToWhenPresent(Supplier<T> valueSupplier) {
        return IsLessThanOrEqualToWhenPresent.of(valueSupplier);
    }

    @SafeVarargs
    public static <T> IsIn<T> isIn(T ... values) {
        return IsIn.of(values);
    }

    public static <T> IsIn<T> isIn(Collection<T> values) {
        return IsIn.of(values);
    }

    public static <T> IsInWithSubselect<T> isIn(Buildable<SelectModel> selectModelBuilder) {
        return IsInWithSubselect.of(selectModelBuilder);
    }

    @SafeVarargs
    public static <T> IsInWhenPresent<T> isInWhenPresent(T ... values) {
        return IsInWhenPresent.of(values);
    }

    public static <T> IsInWhenPresent<T> isInWhenPresent(Collection<T> values) {
        return IsInWhenPresent.of(values);
    }

    @SafeVarargs
    public static <T> IsNotIn<T> isNotIn(T ... values) {
        return IsNotIn.of(values);
    }

    public static <T> IsNotIn<T> isNotIn(Collection<T> values) {
        return IsNotIn.of(values);
    }

    public static <T> IsNotInWithSubselect<T> isNotIn(Buildable<SelectModel> selectModelBuilder) {
        return IsNotInWithSubselect.of(selectModelBuilder);
    }

    @SafeVarargs
    public static <T> IsNotInWhenPresent<T> isNotInWhenPresent(T ... values) {
        return IsNotInWhenPresent.of(values);
    }

    public static <T> IsNotInWhenPresent<T> isNotInWhenPresent(Collection<T> values) {
        return IsNotInWhenPresent.of(values);
    }

    public static <T> IsBetween.Builder<T> isBetween(T value1) {
        return SqlBuilder.isBetween(() -> value1);
    }

    public static <T> IsBetween.Builder<T> isBetween(Supplier<T> valueSupplier1) {
        return IsBetween.isBetween(valueSupplier1);
    }

    public static <T> IsBetweenWhenPresent.Builder<T> isBetweenWhenPresent(T value1) {
        return SqlBuilder.isBetweenWhenPresent(() -> value1);
    }

    public static <T> IsBetweenWhenPresent.Builder<T> isBetweenWhenPresent(Supplier<T> valueSupplier1) {
        return IsBetweenWhenPresent.isBetweenWhenPresent(valueSupplier1);
    }

    public static <T> IsNotBetween.Builder<T> isNotBetween(T value1) {
        return SqlBuilder.isNotBetween(() -> value1);
    }

    public static <T> IsNotBetween.Builder<T> isNotBetween(Supplier<T> valueSupplier1) {
        return IsNotBetween.isNotBetween(valueSupplier1);
    }

    public static <T> IsNotBetweenWhenPresent.Builder<T> isNotBetweenWhenPresent(T value1) {
        return SqlBuilder.isNotBetweenWhenPresent(() -> value1);
    }

    public static <T> IsNotBetweenWhenPresent.Builder<T> isNotBetweenWhenPresent(Supplier<T> valueSupplier1) {
        return IsNotBetweenWhenPresent.isNotBetweenWhenPresent(valueSupplier1);
    }

    public static <T> IsLike<T> isLike(T value) {
        return SqlBuilder.isLike(() -> value);
    }

    public static <T> IsLike<T> isLike(Supplier<T> valueSupplier) {
        return IsLike.of(valueSupplier);
    }

    public static <T> IsLikeWhenPresent<T> isLikeWhenPresent(T value) {
        return SqlBuilder.isLikeWhenPresent(() -> value);
    }

    public static <T> IsLikeWhenPresent<T> isLikeWhenPresent(Supplier<T> valueSupplier) {
        return IsLikeWhenPresent.of(valueSupplier);
    }

    public static <T> IsNotLike<T> isNotLike(T value) {
        return SqlBuilder.isNotLike(() -> value);
    }

    public static <T> IsNotLike<T> isNotLike(Supplier<T> valueSupplier) {
        return IsNotLike.of(valueSupplier);
    }

    public static <T> IsNotLikeWhenPresent<T> isNotLikeWhenPresent(T value) {
        return SqlBuilder.isNotLikeWhenPresent(() -> value);
    }

    public static <T> IsNotLikeWhenPresent<T> isNotLikeWhenPresent(Supplier<T> valueSupplier) {
        return IsNotLikeWhenPresent.of(valueSupplier);
    }

    public static IsEqualTo<Boolean> isTrue() {
        return SqlBuilder.isEqualTo(Boolean.TRUE);
    }

    public static IsEqualTo<Boolean> isFalse() {
        return SqlBuilder.isEqualTo(Boolean.FALSE);
    }

    public static IsLikeCaseInsensitive isLikeCaseInsensitive(String value) {
        return SqlBuilder.isLikeCaseInsensitive(() -> value);
    }

    public static IsLikeCaseInsensitive isLikeCaseInsensitive(Supplier<String> valueSupplier) {
        return IsLikeCaseInsensitive.of(valueSupplier);
    }

    public static IsLikeCaseInsensitiveWhenPresent isLikeCaseInsensitiveWhenPresent(String value) {
        return SqlBuilder.isLikeCaseInsensitiveWhenPresent(() -> value);
    }

    public static IsLikeCaseInsensitiveWhenPresent isLikeCaseInsensitiveWhenPresent(Supplier<String> valueSupplier) {
        return IsLikeCaseInsensitiveWhenPresent.of(valueSupplier);
    }

    public static IsNotLikeCaseInsensitive isNotLikeCaseInsensitive(String value) {
        return SqlBuilder.isNotLikeCaseInsensitive(() -> value);
    }

    public static IsNotLikeCaseInsensitive isNotLikeCaseInsensitive(Supplier<String> valueSupplier) {
        return IsNotLikeCaseInsensitive.of(valueSupplier);
    }

    public static IsNotLikeCaseInsensitiveWhenPresent isNotLikeCaseInsensitiveWhenPresent(String value) {
        return SqlBuilder.isNotLikeCaseInsensitiveWhenPresent(() -> value);
    }

    public static IsNotLikeCaseInsensitiveWhenPresent isNotLikeCaseInsensitiveWhenPresent(Supplier<String> valueSupplier) {
        return IsNotLikeCaseInsensitiveWhenPresent.of(valueSupplier);
    }

    public static IsInCaseInsensitive isInCaseInsensitive(String ... values) {
        return IsInCaseInsensitive.of(values);
    }

    public static IsInCaseInsensitive isInCaseInsensitive(Collection<String> values) {
        return IsInCaseInsensitive.of(values);
    }

    public static IsInCaseInsensitiveWhenPresent isInCaseInsensitiveWhenPresent(String ... values) {
        return IsInCaseInsensitiveWhenPresent.of(values);
    }

    public static IsInCaseInsensitiveWhenPresent isInCaseInsensitiveWhenPresent(Collection<String> values) {
        return IsInCaseInsensitiveWhenPresent.of(values);
    }

    public static IsNotInCaseInsensitive isNotInCaseInsensitive(String ... values) {
        return IsNotInCaseInsensitive.of(values);
    }

    public static IsNotInCaseInsensitive isNotInCaseInsensitive(Collection<String> values) {
        return IsNotInCaseInsensitive.of(values);
    }

    public static IsNotInCaseInsensitiveWhenPresent isNotInCaseInsensitiveWhenPresent(String ... values) {
        return IsNotInCaseInsensitiveWhenPresent.of(values);
    }

    public static IsNotInCaseInsensitiveWhenPresent isNotInCaseInsensitiveWhenPresent(Collection<String> values) {
        return IsNotInCaseInsensitiveWhenPresent.of(values);
    }

    public static SortSpecification sortColumn(String name) {
        return SimpleSortSpecification.of(name);
    }

    public static class InsertIntoNextStep {
        private final SqlTable table;

        private InsertIntoNextStep(SqlTable table) {
            this.table = Objects.requireNonNull(table);
        }

        public InsertSelectDSL withSelectStatement(Buildable<SelectModel> selectModelBuilder) {
            return InsertSelectDSL.insertInto(this.table).withSelectStatement(selectModelBuilder);
        }

        public InsertSelectDSL.SelectGatherer withColumnList(SqlColumn<?> ... columns) {
            return InsertSelectDSL.insertInto(this.table).withColumnList(columns);
        }

        public <T> GeneralInsertDSL.SetClauseFinisher<T> set(SqlColumn<T> column) {
            return GeneralInsertDSL.insertInto(this.table).set(column);
        }
    }
}

