/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.Callback;
import org.mybatis.dynamic.sql.ConditionVisitor;
import org.mybatis.dynamic.sql.VisitableCondition;

public abstract class AbstractListValueCondition<T, S extends AbstractListValueCondition<T, S>>
implements VisitableCondition<T> {
    protected final Collection<T> values;
    protected final UnaryOperator<Stream<T>> valueStreamTransformer;
    protected final Callback emptyCallback;

    protected AbstractListValueCondition(AbstractListConditionBuilder<T, ?> builder) {
        this.valueStreamTransformer = Objects.requireNonNull(builder.valueStreamTransformer);
        this.values = ((Stream)this.valueStreamTransformer.apply(builder.values.stream())).collect(Collectors.toList());
        this.emptyCallback = Objects.requireNonNull(builder.emptyCallback);
    }

    public final <R> Stream<R> mapValues(Function<T, R> mapper) {
        return this.values.stream().map(mapper);
    }

    @Override
    public boolean shouldRender() {
        if (this.values.isEmpty()) {
            this.emptyCallback.call();
            return false;
        }
        return true;
    }

    @Override
    public <R> R accept(ConditionVisitor<T, R> visitor) {
        return visitor.visit(this);
    }

    public abstract S withListEmptyCallback(Callback var1);

    public abstract String renderCondition(String var1, Stream<String> var2);

    public static abstract class AbstractListConditionBuilder<T, S extends AbstractListConditionBuilder<T, S>> {
        protected Collection<T> values = new ArrayList<T>();
        protected UnaryOperator<Stream<T>> valueStreamTransformer = UnaryOperator.identity();
        protected Callback emptyCallback = () -> {};

        public S withValues(Collection<T> values) {
            this.values.addAll(values);
            return this.getThis();
        }

        public S withValueStreamTransformer(UnaryOperator<Stream<T>> valueStreamTransformer) {
            this.valueStreamTransformer = valueStreamTransformer;
            return this.getThis();
        }

        public S withEmptyCallback(Callback emptyCallback) {
            this.emptyCallback = emptyCallback;
            return this.getThis();
        }

        protected abstract S getThis();
    }
}

