/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.caches.redis;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheException;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.mybatis.caches.redis.ConfigWithHost;

final class RedisConfigurationBuilder {
    private static final RedisConfigurationBuilder INSTANCE = new RedisConfigurationBuilder();
    private static final String SYSTEM_PROPERTY_REDIS_PROPERTIES_FILENAME = "redis.properties.filename";
    private static final String REDIS_RESOURCE = "redis.properties";
    private final String redisPropertiesFilename = System.getProperty("redis.properties.filename", "redis.properties");

    private RedisConfigurationBuilder() {
    }

    public static RedisConfigurationBuilder getInstance() {
        return INSTANCE;
    }

    public ConfigWithHost parseConfiguration() {
        return this.parseConfiguration(this.getClass().getClassLoader());
    }

    public ConfigWithHost parseConfiguration(ClassLoader classLoader) {
        Properties config = new Properties();
        InputStream input = classLoader.getResourceAsStream(this.redisPropertiesFilename);
        if (input != null) {
            try {
                config.load(input);
            }
            catch (IOException e) {
                throw new RuntimeException("An error occurred while reading classpath property '" + this.redisPropertiesFilename + "', see nested exceptions", e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        ConfigWithHost jedisConfig = new ConfigWithHost();
        jedisConfig.setHost("localhost");
        this.setConfigProperties(config, jedisConfig);
        return jedisConfig;
    }

    private void setConfigProperties(Properties properties, ConfigWithHost jedisConfig) {
        if (properties != null) {
            MetaObject metaCache = SystemMetaObject.forObject((Object)((Object)jedisConfig));
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!metaCache.hasSetter(name)) continue;
                Class type = metaCache.getSetterType(name);
                if (String.class == type) {
                    metaCache.setValue(name, (Object)value);
                    continue;
                }
                if (Integer.TYPE == type || Integer.class == type) {
                    metaCache.setValue(name, (Object)Integer.valueOf(value));
                    continue;
                }
                if (Long.TYPE == type || Long.class == type) {
                    metaCache.setValue(name, (Object)Long.valueOf(value));
                    continue;
                }
                if (Short.TYPE == type || Short.class == type) {
                    metaCache.setValue(name, (Object)Short.valueOf(value));
                    continue;
                }
                if (Byte.TYPE == type || Byte.class == type) {
                    metaCache.setValue(name, (Object)Byte.valueOf(value));
                    continue;
                }
                if (Float.TYPE == type || Float.class == type) {
                    metaCache.setValue(name, (Object)Float.valueOf(value));
                    continue;
                }
                if (Boolean.TYPE == type || Boolean.class == type) {
                    metaCache.setValue(name, (Object)Boolean.valueOf(value));
                    continue;
                }
                if (Double.TYPE == type || Double.class == type) {
                    metaCache.setValue(name, (Object)Double.valueOf(value));
                    continue;
                }
                throw new CacheException("Unsupported property type: '" + name + "' of type " + type);
            }
        }
    }
}

