/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.jetty.server.Server;

public class Monitor
extends Thread {
    private String _key;
    private Server[] _servers;
    ServerSocket _serverSocket;
    boolean _kill;

    public Monitor(int port, String key, Server[] servers, boolean kill) throws UnknownHostException, IOException {
        if (port <= 0) {
            throw new IllegalStateException("Bad stop port");
        }
        if (key == null) {
            throw new IllegalStateException("Bad stop key");
        }
        this._key = key;
        this._servers = servers;
        this._kill = kill;
        this.setDaemon(true);
        this.setName("StopJettyPluginMonitor");
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", port);
        this._serverSocket = new ServerSocket();
        this._serverSocket.setReuseAddress(true);
        try {
            this._serverSocket.bind(address, 1);
        }
        catch (IOException x) {
            System.out.println("Error binding to stop port 127.0.0.1:" + port);
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this._serverSocket != null) {
            Socket socket = null;
            try {
                socket = this._serverSocket.accept();
                socket.setSoLinger(false, 0);
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                String key = lin.readLine();
                if (!this._key.equals(key)) continue;
                String cmd = lin.readLine();
                if ("stop".equals(cmd)) {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        this._serverSocket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this._serverSocket = null;
                    if (this._kill) {
                        System.out.println("Killing Jetty");
                        System.exit(0);
                        continue;
                    }
                    for (int i = 0; this._servers != null && i < this._servers.length; ++i) {
                        try {
                            System.out.println("Stopping server " + i);
                            this._servers[i].stop();
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
                System.out.println("Unsupported monitor operation");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                socket = null;
            }
        }
    }
}

