/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.FileSystemBinaryStore;
import org.modeshape.jcr.value.binary.StoredBinaryValue;
import org.modeshape.jcr.value.binary.TransientBinaryStore;

public class MongodbBinaryStore
extends AbstractBinaryStore {
    private static final String DEFAULT_DB_NAME = "ModeShape_BinaryStore";
    private static final String FIELD_CHUNK_TYPE = "chunk-type";
    private static final String FIELD_MIME_TYPE = "mime-type";
    private static final String FIELD_EXTRACTED_TEXT = "extracted-text";
    private static final String FIELD_UNUSED_SINCE = "unused-since";
    private static final String FIELD_UNUSED = "unused";
    private static final String FIELD_CHUNK_SIZE = "chunk-size";
    private static final String FIELD_CHUNK_BUFFER = "chunk-buffer";
    private static final String FIELD_CHUNK_POSITION = "chunk-order";
    private static final String FIELD_CHUNK_VERSION = "chunk-version";
    private static final String CHUNK_TYPE_HEADER = "header";
    private static final String CHUNK_TYPE_DATA_CHUNK = "data";
    private static final int VERSION_1 = 1;
    protected static final BasicDBObject HEADER_QUERY = new BasicDBObject().append("chunk-type", (Object)"header");
    protected static final BasicDBObject DATA_CHUNK_QUERY = new BasicDBObject().append("chunk-type", (Object)"data");
    protected static final BasicDBObject DATA_CHUNK_SORT_INDEX = new BasicDBObject().append("chunk-order", (Object)1);
    private FileSystemBinaryStore cache;
    private String database;
    private String username;
    private String password;
    private Set<String> hostAddresses = new LinkedHashSet<String>();
    private DB db;
    protected int chunkSize = 1024;

    public MongodbBinaryStore(String host, Integer port, String database, String username, String password, List<String> hostAddresses) {
        String defaultServer;
        this.cache = TransientBinaryStore.get();
        this.database = !StringUtil.isBlank((String)database) ? database : DEFAULT_DB_NAME;
        this.username = username;
        this.password = password;
        boolean hostAddressesProvided = hostAddresses != null && !hostAddresses.isEmpty();
        this.hostAddresses = new LinkedHashSet<String>();
        String string = defaultServer = !StringUtil.isBlank((String)host) && port != null ? host + ":" + port : null;
        if (defaultServer == null && !hostAddressesProvided) {
            throw new IllegalArgumentException("Invalid Mongo binary store configuration: either (host and port) or host addresses have to provided");
        }
        if (defaultServer != null) {
            this.hostAddresses.add(defaultServer);
        }
        if (hostAddressesProvided) {
            this.hostAddresses.addAll(hostAddresses);
        }
    }

    private List<ServerAddress> convertToServerAddresses(Set<String> addresses) {
        return addresses.stream().map(this::stringToServerAddress).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ServerAddress stringToServerAddress(String address) {
        int port;
        if (address == null || address.trim().length() == 0) {
            return null;
        }
        String[] tokens = address.split(":");
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Wrong address format: " + address + " (expected host:port)");
        }
        String host = tokens[0];
        try {
            port = Integer.parseInt(tokens[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Wrong address format: " + address + " (expected host:port)");
        }
        try {
            return new ServerAddress(host, port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryValue storeValue(InputStream stream, boolean markAsUnused) throws BinaryStoreException {
        BinaryValue temp = this.cache.storeValue(stream, markAsUnused);
        try {
            BinaryKey key = new BinaryKey(temp.getKey().toString());
            if (this.db.collectionExists(key.toString())) {
                StoredBinaryValue storedBinaryValue = new StoredBinaryValue(this, key, temp.getSize());
                return storedBinaryValue;
            }
            DBCollection content = this.db.getCollection(key.toString());
            content.createIndex((DBObject)DATA_CHUNK_SORT_INDEX);
            ChunkOutputStream dbStream = markAsUnused ? new ChunkOutputStream(content, System.currentTimeMillis()) : new ChunkOutputStream(content);
            try {
                IoUtil.write((InputStream)temp.getStream(), (OutputStream)dbStream);
            }
            catch (Exception e) {
                throw new BinaryStoreException(e);
            }
            StoredBinaryValue storedBinaryValue = new StoredBinaryValue(this, key, temp.getSize());
            return storedBinaryValue;
        }
        finally {
            this.cache.markAsUnused(temp.getKey());
        }
    }

    @Override
    public InputStream getInputStream(BinaryKey key) throws BinaryStoreException {
        if (!this.db.collectionExists(key.toString())) {
            throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{key, this.db.getName()}));
        }
        return new ChunkInputStream(this.db.getCollection(key.toString()));
    }

    @Override
    public void markAsUsed(Iterable<BinaryKey> keys) {
        for (BinaryKey key : keys) {
            if (!this.db.collectionExists(key.toString())) continue;
            DBCollection content = this.db.getCollection(key.toString());
            this.setAttribute(content, FIELD_UNUSED, false);
            this.setAttribute(content, FIELD_UNUSED_SINCE, null);
        }
    }

    @Override
    public void markAsUnused(Iterable<BinaryKey> keys) {
        for (BinaryKey key : keys) {
            if (!this.db.collectionExists(key.toString())) continue;
            DBCollection content = this.db.getCollection(key.toString());
            this.setAttribute(content, FIELD_UNUSED, true);
            this.setAttribute(content, FIELD_UNUSED_SINCE, System.currentTimeMillis());
        }
    }

    @Override
    public void removeValuesUnusedLongerThan(long minimumAge, TimeUnit unit) {
        long deadline = System.currentTimeMillis() - unit.toMillis(minimumAge);
        Set<String> keys = this.getStoredKeys(false);
        for (String key : keys) {
            DBCollection content = this.db.getCollection(key);
            if (!this.isExpired(content, deadline)) continue;
            content.drop();
        }
    }

    @Override
    protected void storeMimeType(BinaryValue source, String mimeType) throws BinaryStoreException {
        if (!this.db.collectionExists(source.getKey().toString())) {
            throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{source.getKey(), this.db.getName()}));
        }
        DBCollection content = this.db.getCollection(source.getKey().toString());
        this.setAttribute(content, FIELD_MIME_TYPE, mimeType);
    }

    @Override
    protected String getStoredMimeType(BinaryValue source) throws BinaryStoreException {
        if (!this.db.collectionExists(source.getKey().toString())) {
            throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{source.getKey(), this.db.getName()}));
        }
        DBCollection content = this.db.getCollection(source.getKey().toString());
        return (String)this.getAttribute(content, FIELD_MIME_TYPE);
    }

    @Override
    public void storeExtractedText(BinaryValue source, String extractedText) throws BinaryStoreException {
        if (!this.db.collectionExists(source.getKey().toString())) {
            throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{source.getKey(), this.db.getName()}));
        }
        DBCollection content = this.db.getCollection(source.getKey().toString());
        this.setAttribute(content, FIELD_EXTRACTED_TEXT, extractedText);
    }

    @Override
    public String getExtractedText(BinaryValue source) throws BinaryStoreException {
        if (!this.db.collectionExists(source.getKey().toString())) {
            throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{source.getKey(), this.db.getName()}));
        }
        DBCollection content = this.db.getCollection(source.getKey().toString());
        return (String)this.getAttribute(content, FIELD_EXTRACTED_TEXT);
    }

    @Override
    public Iterable<BinaryKey> getAllBinaryKeys() {
        ArrayList<BinaryKey> list = new ArrayList<BinaryKey>();
        Set<String> keys = this.getStoredKeys(true);
        for (String s : keys) {
            list.add(new BinaryKey(s));
        }
        return list;
    }

    private Set<String> getStoredKeys(boolean onlyUsed) {
        HashSet<String> storedKeys = new HashSet<String>();
        Set collectionNames = this.db.getCollectionNames();
        for (String collectionName : collectionNames) {
            DBCollection collection;
            boolean unused;
            if (collectionName.toLowerCase().startsWith("system") || collectionName.toLowerCase().startsWith("local") || (unused = ((Boolean)this.getAttribute(collection = this.db.getCollection(collectionName), FIELD_UNUSED)).booleanValue()) && onlyUsed) continue;
            storedKeys.add(collectionName);
        }
        return storedKeys;
    }

    @Override
    public void start() {
        super.start();
        if (StringUtil.isBlank((String)this.database)) {
            throw new RuntimeException("Database name is not specified");
        }
        this.initMongo(this.username, this.password);
    }

    private void initMongo(String username, String password) {
        ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
        if (!StringUtil.isBlank((String)username) && !StringUtil.isBlank((String)password)) {
            credentials.add(MongoCredential.createCredential((String)username, (String)this.database, (char[])password.toCharArray()));
        }
        MongoClient client = this.hostAddresses.size() > 1 ? new MongoClient(this.convertToServerAddresses(this.hostAddresses), credentials) : new MongoClient(this.stringToServerAddress(this.hostAddresses.iterator().next()), credentials);
        client.setWriteConcern(WriteConcern.ACKNOWLEDGED);
        this.db = client.getDB(this.database);
    }

    private void setAttribute(DBCollection content, String fieldName, Object value) {
        DBObject header = content.findOne((DBObject)HEADER_QUERY);
        BasicDBObject newHeader = new BasicDBObject();
        newHeader.put(FIELD_CHUNK_TYPE, header.get(FIELD_CHUNK_TYPE));
        newHeader.put(FIELD_MIME_TYPE, header.get(FIELD_MIME_TYPE));
        newHeader.put(FIELD_EXTRACTED_TEXT, header.get(FIELD_EXTRACTED_TEXT));
        newHeader.put(FIELD_UNUSED, header.get(FIELD_UNUSED));
        newHeader.put(FIELD_UNUSED_SINCE, header.get(FIELD_UNUSED_SINCE));
        newHeader.put(fieldName, value);
        content.update((DBObject)HEADER_QUERY, (DBObject)newHeader);
    }

    private Object getAttribute(DBCollection content, String fieldName) {
        return content.findOne((DBObject)HEADER_QUERY).get(fieldName);
    }

    private boolean isExpired(DBCollection content, long deadline) {
        Long unusedSince = (Long)this.getAttribute(content, FIELD_UNUSED_SINCE);
        return unusedSince != null && unusedSince < deadline;
    }

    @NotThreadSafe
    protected class ChunkInputStream
    extends InputStream {
        private final DBCursor cursor;
        private byte[] buffer;
        private int offset;
        private DBObject chunk;
        private int size;

        public ChunkInputStream(DBCollection chunks) {
            this.buffer = new byte[MongodbBinaryStore.this.chunkSize];
            this.offset = 0;
            this.chunk = new BasicDBObject();
            this.size = 0;
            this.cursor = this.cursorFor(chunks);
        }

        private DBCursor cursorFor(DBCollection parent) {
            DBObject header = parent.findOne((DBObject)HEADER_QUERY);
            assert (header != null);
            Object version = header.get(MongodbBinaryStore.FIELD_CHUNK_VERSION);
            DBCursor result = parent.find((DBObject)DATA_CHUNK_QUERY);
            if (version == null) {
                return result;
            }
            switch ((Integer)version) {
                case 1: {
                    return result.sort((DBObject)DATA_CHUNK_SORT_INDEX);
                }
            }
            throw new IllegalArgumentException("Unknown chunk version " + version);
        }

        @Override
        public int read() {
            if (this.offset < this.size) {
                return 0xFF & this.buffer[this.offset++];
            }
            if (this.cursor.hasNext()) {
                this.chunk = this.cursor.next();
                this.size = (Integer)this.chunk.get(MongodbBinaryStore.FIELD_CHUNK_SIZE);
                this.buffer = (byte[])this.chunk.get(MongodbBinaryStore.FIELD_CHUNK_BUFFER);
                this.offset = 0;
            }
            if (this.offset < this.size) {
                return 0xFF & this.buffer[this.offset++];
            }
            return -1;
        }
    }

    @NotThreadSafe
    protected class ChunkOutputStream
    extends OutputStream {
        private DBCollection content;
        private byte[] buffer;
        private int offset;
        private int position;
        private BasicDBObject chunk;

        public ChunkOutputStream(DBCollection content) {
            this.buffer = new byte[MongodbBinaryStore.this.chunkSize];
            this.chunk = new BasicDBObject();
            this.content = content;
            BasicDBObject header = new BasicDBObject();
            header.put(MongodbBinaryStore.FIELD_CHUNK_TYPE, (Object)MongodbBinaryStore.CHUNK_TYPE_HEADER);
            header.put(MongodbBinaryStore.FIELD_UNUSED, (Object)false);
            header.put(MongodbBinaryStore.FIELD_CHUNK_VERSION, (Object)1);
            this.content.insert(new DBObject[]{header});
        }

        public ChunkOutputStream(DBCollection content, long unusedSince) {
            this.buffer = new byte[MongodbBinaryStore.this.chunkSize];
            this.chunk = new BasicDBObject();
            this.content = content;
            BasicDBObject header = new BasicDBObject();
            header.put(MongodbBinaryStore.FIELD_CHUNK_TYPE, (Object)MongodbBinaryStore.CHUNK_TYPE_HEADER);
            header.put(MongodbBinaryStore.FIELD_UNUSED, (Object)true);
            header.put(MongodbBinaryStore.FIELD_UNUSED_SINCE, (Object)unusedSince);
            this.content.insert(new DBObject[]{header});
        }

        @Override
        public void write(int b) {
            if (this.offset < this.buffer.length) {
                this.buffer[this.offset++] = (byte)b;
            }
            if (this.offset == this.buffer.length) {
                this.flush();
            }
        }

        @Override
        public void flush() {
            if (this.offset > 0) {
                this.chunk.put(MongodbBinaryStore.FIELD_CHUNK_TYPE, (Object)MongodbBinaryStore.CHUNK_TYPE_DATA_CHUNK);
                this.chunk.put(MongodbBinaryStore.FIELD_CHUNK_SIZE, (Object)this.offset);
                this.chunk.put(MongodbBinaryStore.FIELD_CHUNK_BUFFER, (Object)this.buffer);
                this.chunk.put(MongodbBinaryStore.FIELD_CHUNK_POSITION, (Object)this.position);
                this.content.insert(new DBObject[]{this.chunk});
                this.offset = 0;
                ++this.position;
                this.chunk = new BasicDBObject();
            }
        }
    }
}

