/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.LinkedList;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.plan.PlanNode;

@Immutable
public class ReorderSortAndRemoveDuplicates
implements OptimizerRule {
    public static final ReorderSortAndRemoveDuplicates INSTANCE = new ReorderSortAndRemoveDuplicates();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (PlanNode distinct : plan.findAllAtOrBelow(PlanNode.Traversal.PRE_ORDER, PlanNode.Type.DUP_REMOVE)) {
            if (distinct.getFirstChild().getType() != PlanNode.Type.SORT) continue;
            PlanNode parent = distinct.getParent();
            PlanNode sort = distinct.getFirstChild();
            assert (sort.getParent() == distinct);
            sort.removeFromParent();
            assert (sort.getParent() == null);
            distinct.addChildren(sort.getChildren());
            assert (sort.getChildCount() == 0);
            assert (sort.getParent() == null);
            parent.replaceChild(distinct, sort);
            assert (sort.getParent() == parent);
            assert (sort.getChildCount() == 0);
            assert (distinct.getParent() == null);
            distinct.setParent(sort);
            assert (distinct.getParent() == sort);
            assert (sort.getParent() == parent);
        }
        return plan;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

