/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.query.model.Order;
import org.modeshape.jcr.query.model.Readable;

public enum NullOrder implements Readable
{
    NULLS_FIRST("NULLS FIRST"),
    NULLS_LAST("NULLS LAST");

    private final String symbol;

    public static NullOrder defaultOrder(Order order) {
        return order == Order.ASCENDING ? NULLS_LAST : NULLS_FIRST;
    }

    private NullOrder(String symbol) {
        this.symbol = symbol;
    }

    public String symbol() {
        return this.symbol;
    }

    public String toString() {
        return this.symbol;
    }

    public static NullOrder forSymbol(String symbol) {
        CheckArg.isNotNull((Object)symbol, (String)"symbol");
        if (NULLS_FIRST.symbol().equalsIgnoreCase(symbol)) {
            return NULLS_FIRST;
        }
        if (NULLS_LAST.symbol().equalsIgnoreCase(symbol)) {
            return NULLS_LAST;
        }
        return null;
    }

    @Override
    public String getString() {
        return this.symbol();
    }
}

