/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.locking;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.locking.LockingService;
import org.modeshape.schematic.Lockable;

public class DbLockingService
implements LockingService {
    private final Lockable db;
    private final long lockTimeoutMillis;

    public DbLockingService(long lockTimeoutMillis, Lockable db) {
        CheckArg.isNonNegative((long)lockTimeoutMillis, (String)"lockTimeout");
        this.lockTimeoutMillis = lockTimeoutMillis;
        this.db = db;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit, String ... names) throws InterruptedException {
        boolean result;
        long start = System.currentTimeMillis();
        long timeInMills = TimeUnit.MILLISECONDS.convert(time, unit);
        while (!(result = this.db.lockForWriting(names)) && System.currentTimeMillis() - start <= timeInMills) {
            long sleepDurationMillis = 50 + ThreadLocalRandom.current().nextInt(251);
            Thread.sleep(sleepDurationMillis);
        }
        return result;
    }

    @Override
    public boolean tryLock(String ... names) throws InterruptedException {
        return this.tryLock(this.lockTimeoutMillis, TimeUnit.MILLISECONDS, names);
    }

    @Override
    public boolean unlock(String ... names) {
        return true;
    }

    @Override
    public boolean shutdown() {
        return true;
    }
}

