/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.query.qom.Constraint;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DB;
import org.modeshape.jcr.index.local.IndexValues;
import org.modeshape.jcr.index.local.LocalIndex;
import org.modeshape.jcr.index.local.Operations;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.provider.Filter;

final class LocalEnumeratedIndex
extends LocalIndex<String> {
    protected final ConcurrentNavigableMap<String, Set<String>> nodeKeySetsByValue;
    private final IndexValues.Converter<String> converter;
    private final Set<String> possibleValues;
    private final boolean isNew;
    private final AtomicLong totalCount = new AtomicLong(0L);

    static LocalEnumeratedIndex create(String name, String workspaceName, DB db, IndexValues.Converter<String> converter, BTreeKeySerializer<String> valueSerializer, Set<String> enumeratedValues) {
        return new LocalEnumeratedIndex(name, workspaceName, db, converter, valueSerializer, enumeratedValues);
    }

    static LocalEnumeratedIndex create(String name, String workspaceName, DB db, IndexValues.Converter<String> converter, BTreeKeySerializer<String> valueSerializer) {
        return new LocalEnumeratedIndex(name, workspaceName, db, converter, valueSerializer, null);
    }

    LocalEnumeratedIndex(String name, String workspaceName, DB db, IndexValues.Converter<String> converter, BTreeKeySerializer<String> valueSerializer, Set<String> possibleValues) {
        super(name, workspaceName, db);
        this.converter = converter;
        this.possibleValues = possibleValues != null ? new HashSet<String>(possibleValues) : new HashSet();
        this.nodeKeySetsByValue = new ConcurrentSkipListMap<String, Set<String>>();
        boolean foundContent = false;
        for (String collectionName : db.getAll().keySet()) {
            String prefix;
            if (!collectionName.startsWith(prefix = this.name + "/enumerated/")) continue;
            foundContent = true;
            if (collectionName.length() <= prefix.length()) continue;
            String valueString = collectionName.substring(prefix.length());
            Set<String> keysForValue = this.createOrGetKeySet(valueString);
            this.nodeKeySetsByValue.put(valueString, keysForValue);
            this.totalCount.addAndGet(keysForValue.size());
        }
        for (String possibleValue : this.possibleValues) {
            if (this.nodeKeySetsByValue.containsKey(possibleValue)) continue;
            Set<String> keysForValue = this.createOrGetKeySet(possibleValue);
            this.nodeKeySetsByValue.put(possibleValue, keysForValue);
            this.totalCount.addAndGet(keysForValue.size());
        }
        this.isNew = !foundContent;
    }

    private Set<String> createOrGetKeySet(String value) {
        Set<String> keySet;
        Set<String> previous;
        String collectionName = this.collectionName(value);
        if (this.logger.isDebugEnabled()) {
            if (this.db.exists(collectionName)) {
                this.logger.debug("Reopening enum storage '{0}' for '{1}' index in workspace '{2}'", new Object[]{collectionName, this.name, this.workspace});
            } else {
                this.logger.debug("Creating enum storage '{0}' for '{1}' index in workspace '{2}'", new Object[]{collectionName, this.name, this.workspace});
            }
        }
        if ((previous = this.nodeKeySetsByValue.putIfAbsent(value, keySet = this.db.createHashSet(collectionName).counterEnable().makeOrGet())) != null) {
            keySet = previous;
        }
        return keySet;
    }

    private String collectionName(String value) {
        return this.name + "/enumerated/" + value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getWorkspaceName() {
        return this.workspace;
    }

    @Override
    public boolean requiresReindexing() {
        return this.isNew;
    }

    protected final IndexValues.Converter<String> converter() {
        return this.converter;
    }

    @Override
    public long estimateTotalCount() {
        return this.totalCount.get();
    }

    @Override
    public Filter.Results filter(IndexConstraints filter, long cardinalityEstimate) {
        return Operations.createEnumeratedFilter(this.nodeKeySetsByValue, this.converter, filter.getConstraints(), filter.getVariables()).getResults();
    }

    @Override
    public long estimateCardinality(List<Constraint> andedConstraints, Map<String, Object> variables) {
        return Operations.createEnumeratedFilter(this.nodeKeySetsByValue, this.converter, andedConstraints, variables).estimateCount();
    }

    @Override
    public void add(String nodeKey, String propertyName, String value) {
        Set keySet = this.nodeKeySetsByValue.computeIfAbsent(value, this::createOrGetKeySet);
        if (keySet.add(nodeKey)) {
            this.totalCount.incrementAndGet();
        }
    }

    @Override
    public void remove(String nodeKey) {
        for (Set nodeKeySet : this.nodeKeySetsByValue.values()) {
            if (!nodeKeySet.remove(nodeKey)) continue;
            this.totalCount.decrementAndGet();
        }
    }

    @Override
    public void remove(String nodeKey, String propertyName, String value) {
        Set nodeKeySet = (Set)this.nodeKeySetsByValue.get(value);
        if (nodeKeySet != null && nodeKeySet.remove(nodeKey)) {
            this.totalCount.decrementAndGet();
        }
    }

    @Override
    public synchronized void clearAllData() {
        for (Map.Entry entry : this.nodeKeySetsByValue.entrySet()) {
            ((Set)entry.getValue()).clear();
            String collectionName = this.collectionName((String)entry.getKey());
            if (!this.db.exists(collectionName)) continue;
            this.db.delete(collectionName);
        }
        this.nodeKeySetsByValue.clear();
        this.totalCount.set(0L);
    }

    @Override
    public synchronized void shutdown(boolean destroyed) {
        if (destroyed) {
            for (String value : this.nodeKeySetsByValue.keySet()) {
                String collectionName = this.collectionName(value);
                if (!this.db.exists(collectionName)) continue;
                this.db.delete(collectionName);
            }
            this.nodeKeySetsByValue.clear();
            this.totalCount.set(0L);
        }
    }
}

