/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrNodeListIterator;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSharedNode;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.value.Path;

final class JcrSharedNodeCache {
    private final ConcurrentMap<NodeKey, SharedSet> sharedSets = new ConcurrentHashMap<NodeKey, SharedSet>();
    protected final JcrSession session;

    JcrSharedNodeCache(JcrSession session) {
        this.session = session;
    }

    public JcrSession session() {
        return this.session;
    }

    public SharedSet getSharedSet(AbstractJcrNode shareableNode) {
        NodeKey shareableNodeKey = shareableNode.key();
        return this.sharedSets.computeIfAbsent(shareableNodeKey, key -> new SharedSet(shareableNode));
    }

    protected void clear() {
        this.sharedSets.clear();
    }

    public void destroyed(NodeKey shareableNodeKey) {
        this.sharedSets.remove(shareableNodeKey);
    }

    public void removed(AbstractJcrNode shareableNode) throws RepositoryException {
        NodeKey shareableNodeKey = shareableNode.key();
        SharedSet sharedSet = this.getSharedSet(shareableNode);
        if (sharedSet.shareableNode == shareableNode) {
            this.session().releaseCachedNode(shareableNode);
            AbstractJcrNode newShared = this.session().node(shareableNodeKey, null);
            SharedSet newSharedSet = new SharedSet(newShared);
            this.sharedSets.put(shareableNodeKey, newSharedSet);
        } else {
            assert (shareableNode instanceof JcrSharedNode);
            sharedSet.remove((JcrSharedNode)shareableNode);
        }
    }

    final class SharedSet {
        protected final AbstractJcrNode shareableNode;
        private final ConcurrentMap<NodeKey, JcrSharedNode> sharedNodesByParentKey = new ConcurrentHashMap<NodeKey, JcrSharedNode>();

        protected SharedSet(AbstractJcrNode shareableNode) {
            this.shareableNode = shareableNode;
            assert (this.shareableNode != null);
        }

        public final NodeKey key() {
            return this.shareableNode.key();
        }

        public final JcrSession session() {
            return JcrSharedNodeCache.this.session();
        }

        public AbstractJcrNode getSharedNode(CachedNode cachedNode, NodeKey parentKey) {
            assert (parentKey != null);
            try {
                SessionCache cache;
                Set<NodeKey> additionalParents;
                NodeKey actualParentKey = this.shareableNode.parentKey();
                assert (actualParentKey != null);
                if (!actualParentKey.equals(parentKey) && (additionalParents = cachedNode.getAdditionalParentKeys(cache = JcrSharedNodeCache.this.session.cache())).contains(parentKey) && JcrSharedNodeCache.this.session.nodeExists(parentKey)) {
                    return this.getOrCreateSharedNode(parentKey);
                }
                return this.shareableNode;
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }

        public AbstractJcrNode getSharedNodeAtOrBelow(Path path) throws RepositoryException, ItemNotFoundException, InvalidItemStateException {
            NodeIterator iter = this.getSharedNodes();
            while (iter.hasNext()) {
                AbstractJcrNode shared = (AbstractJcrNode)iter.nextNode();
                if (!shared.path().isAtOrBelow(path)) continue;
                return shared;
            }
            return null;
        }

        protected void remove(JcrSharedNode sharedNode) {
            this.sharedNodesByParentKey.remove(sharedNode.parentKey());
        }

        private JcrSharedNode getOrCreateSharedNode(NodeKey parentKey) {
            JcrSharedNode newShared;
            assert (parentKey != null);
            JcrSharedNode sharedNode = (JcrSharedNode)this.sharedNodesByParentKey.get(parentKey);
            if (sharedNode == null && (sharedNode = this.sharedNodesByParentKey.putIfAbsent(parentKey, newShared = new JcrSharedNode(this, parentKey))) == null) {
                sharedNode = newShared;
            }
            return sharedNode;
        }

        public int getSize() throws RepositoryException {
            SessionCache cache = this.session().cache();
            Set<NodeKey> additionalParents = this.shareableNode.node().getAdditionalParentKeys(cache);
            return additionalParents.size() + 1;
        }

        public NodeIterator getSharedNodes() throws RepositoryException {
            SessionCache cache = this.session().cache();
            Set<NodeKey> additionalParents = this.shareableNode.node().getAdditionalParentKeys(cache);
            NodeKey key = this.shareableNode.key();
            String workspaceKey = key.getWorkspaceKey();
            ArrayList<AbstractJcrNode> sharedNodes = new ArrayList<AbstractJcrNode>(additionalParents.size() + 1);
            sharedNodes.add(this.shareableNode);
            for (NodeKey parentKey : additionalParents) {
                if (!workspaceKey.equals(parentKey.getWorkspaceKey()) || !JcrSharedNodeCache.this.session.nodeExists(parentKey)) continue;
                sharedNodes.add(this.getOrCreateSharedNode(parentKey));
            }
            return new JcrNodeListIterator(sharedNodes.iterator(), sharedNodes.size());
        }
    }
}

