/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.RepositoryException;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrRepositoryMonitor;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.api.BackupOptions;
import org.modeshape.jcr.api.Problems;
import org.modeshape.jcr.api.RepositoryManager;
import org.modeshape.jcr.api.RestoreOptions;
import org.modeshape.jcr.value.Path;

public class JcrRepositoryManager
implements RepositoryManager {
    private final Lock lock = new ReentrantLock();
    private final JcrWorkspace workspace;
    private JcrRepositoryMonitor monitor;

    protected JcrRepositoryManager(JcrWorkspace workspace) {
        this.workspace = workspace;
    }

    public JcrWorkspace getWorkspace() {
        return this.workspace;
    }

    private final JcrSession session() {
        return this.workspace.getSession();
    }

    private final JcrRepository repository() {
        return this.workspace.repository();
    }

    public JcrRepositoryMonitor getRepositoryMonitor() throws RepositoryException {
        this.session().checkLive();
        return this.repositoryMonitor();
    }

    final JcrRepositoryMonitor repositoryMonitor() throws RepositoryException {
        if (this.monitor == null) {
            try {
                this.lock.lock();
                if (this.monitor == null) {
                    this.monitor = new JcrRepositoryMonitor(this.session());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.monitor;
    }

    public Problems backupRepository(File backupDirectory) throws RepositoryException {
        return this.backupRepository(backupDirectory, BackupOptions.DEFAULT);
    }

    public Problems backupRepository(File backupDirectory, BackupOptions backupOptions) throws RepositoryException {
        this.session().checkPermission(Path.ROOT_PATH, "backup");
        return this.repository().runningState().backupService().backupRepository(backupDirectory, backupOptions);
    }

    public Problems restoreRepository(File backupDirectory) throws RepositoryException {
        return this.restoreRepository(backupDirectory, RestoreOptions.DEFAULT);
    }

    public Problems restoreRepository(File backupDirectory, RestoreOptions options) throws RepositoryException {
        this.session().checkPermission(Path.ROOT_PATH, "restore");
        return this.repository().runningState().backupService().restoreRepository(this.repository(), backupDirectory, options);
    }
}

