/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.internal.model.ForgedMethodHistory;
import org.mapstruct.ap.internal.model.beanmapping.MappingReferences;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.MappingMethodOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.ParameterProvidedMethods;
import org.mapstruct.ap.internal.util.Strings;

public class ForgedMethod
implements Method {
    private final List<Parameter> parameters;
    private final Type returnType;
    private final String name;
    private final List<Type> thrownTypes;
    private final ForgedMethodHistory history;
    private final List<Parameter> sourceParameters;
    private final List<Parameter> contextParameters;
    private final Parameter mappingTargetParameter;
    private final MappingReferences mappingReferences;
    private final Method basedOn;
    private final boolean forgedNameBased;
    private MappingMethodOptions options;

    public static ForgedMethod forParameterMapping(String name, Type sourceType, Type returnType, Method basedOn) {
        return new ForgedMethod(name, sourceType, returnType, Collections.emptyList(), basedOn, null, MappingReferences.empty(), false);
    }

    public static ForgedMethod forPropertyMapping(String name, Type sourceType, Type returnType, List<Parameter> parameters, Method basedOn, ForgedMethodHistory history, MappingReferences mappingReferences, boolean forgedNameBased) {
        return new ForgedMethod(name, sourceType, returnType, parameters, basedOn, history, mappingReferences == null ? MappingReferences.empty() : mappingReferences, forgedNameBased);
    }

    public static ForgedMethod forElementMapping(String name, Type sourceType, Type returnType, Method basedOn, ForgedMethodHistory history, boolean forgedNameBased) {
        return new ForgedMethod(name, sourceType, returnType, basedOn.getContextParameters(), basedOn, history, MappingReferences.empty(), forgedNameBased);
    }

    public static ForgedMethod forSubclassMapping(String name, Type sourceType, Type returnType, Method basedOn, MappingReferences mappingReferences, ForgedMethodHistory history, boolean forgedNameBased) {
        return new ForgedMethod(name, sourceType, returnType, basedOn.getContextParameters(), basedOn, history, mappingReferences == null ? MappingReferences.empty() : mappingReferences, forgedNameBased);
    }

    private ForgedMethod(String name, Type sourceType, Type returnType, List<Parameter> additionalParameters, Method basedOn, ForgedMethodHistory history, MappingReferences mappingReferences, boolean forgedNameBased) {
        String sourceParamSafeName = additionalParameters.isEmpty() ? Strings.getSafeVariableName(sourceType.getName(), new String[0]) : Strings.getSafeVariableName(sourceType.getName(), additionalParameters.stream().map(Parameter::getName).collect(Collectors.toList()));
        this.parameters = new ArrayList<Parameter>(1 + additionalParameters.size());
        Parameter sourceParameter = new Parameter(sourceParamSafeName, sourceType);
        this.parameters.add(sourceParameter);
        this.parameters.addAll(additionalParameters);
        this.sourceParameters = Parameter.getSourceParameters(this.parameters);
        this.contextParameters = Parameter.getContextParameters(this.parameters);
        this.mappingTargetParameter = Parameter.getMappingTargetParameter(this.parameters);
        this.returnType = returnType;
        this.thrownTypes = new ArrayList<Type>();
        this.basedOn = basedOn;
        this.name = Strings.sanitizeIdentifierName(name);
        this.history = history;
        this.mappingReferences = mappingReferences;
        this.forgedNameBased = forgedNameBased;
        this.options = MappingMethodOptions.getForgedMethodInheritedOptions(basedOn.getOptions());
    }

    public ForgedMethod(String name, ForgedMethod forgedMethod) {
        this.parameters = forgedMethod.parameters;
        this.returnType = forgedMethod.returnType;
        this.thrownTypes = new ArrayList<Type>();
        this.history = forgedMethod.history;
        this.sourceParameters = Parameter.getSourceParameters(this.parameters);
        this.contextParameters = Parameter.getContextParameters(this.parameters);
        this.mappingTargetParameter = Parameter.getMappingTargetParameter(this.parameters);
        this.mappingReferences = forgedMethod.mappingReferences;
        this.basedOn = forgedMethod.basedOn;
        this.name = name;
        this.forgedNameBased = forgedMethod.forgedNameBased;
        this.options = MappingMethodOptions.getForgedMethodInheritedOptions(this.basedOn.getOptions());
    }

    @Override
    public boolean matches(List<Type> sourceTypes, Type targetType) {
        if (!targetType.equals(this.returnType)) {
            return false;
        }
        if (this.parameters.size() != sourceTypes.size()) {
            return false;
        }
        Iterator<Type> srcTypeIt = sourceTypes.iterator();
        Iterator<Parameter> paramIt = this.parameters.iterator();
        while (srcTypeIt.hasNext() && paramIt.hasNext()) {
            Parameter param;
            Type sourceType = srcTypeIt.next();
            if (sourceType.equals((param = paramIt.next()).getType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type getDeclaringMapper() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<Parameter> getSourceParameters() {
        return this.sourceParameters;
    }

    @Override
    public List<Parameter> getContextParameters() {
        return this.contextParameters;
    }

    @Override
    public ParameterProvidedMethods getContextProvidedMethods() {
        return this.basedOn.getContextProvidedMethods();
    }

    @Override
    public Parameter getMappingTargetParameter() {
        return this.mappingTargetParameter;
    }

    @Override
    public Parameter getTargetTypeParameter() {
        return null;
    }

    @Override
    public Accessibility getAccessibility() {
        return Accessibility.PROTECTED;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public List<Type> getThrownTypes() {
        return this.thrownTypes;
    }

    public ForgedMethodHistory getHistory() {
        return this.history;
    }

    public boolean isForgedNamedBased() {
        return this.forgedNameBased;
    }

    public void addThrownTypes(List<Type> thrownTypesToAdd) {
        for (Type thrownType : thrownTypesToAdd) {
            if (this.thrownTypes.contains(thrownType)) continue;
            this.thrownTypes.add(thrownType);
        }
    }

    @Override
    public Type getResultType() {
        return this.mappingTargetParameter != null ? this.mappingTargetParameter.getType() : this.returnType;
    }

    @Override
    public List<String> getParameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (Parameter parameter : this.getParameters()) {
            parameterNames.add(parameter.getName());
        }
        return parameterNames;
    }

    @Override
    public boolean overridesMethod() {
        return false;
    }

    @Override
    public ExecutableElement getExecutable() {
        return this.basedOn.getExecutable();
    }

    @Override
    public boolean isLifecycleCallbackMethod() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.returnType.toString());
        sb.append(" ");
        sb.append(this.getName()).append("(").append(Strings.join(this.parameters, ", ")).append(")");
        return sb.toString();
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public Type getDefiningType() {
        return null;
    }

    @Override
    public boolean isUpdateMethod() {
        return this.getMappingTargetParameter() != null;
    }

    @Override
    public boolean isObjectFactory() {
        return false;
    }

    @Override
    public MappingMethodOptions getOptions() {
        return this.options;
    }

    @Override
    public List<Type> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public String describe() {
        return this.getResultType().describe() + ":" + this.getName() + "(" + this.getMappingSourceType().describe() + ")";
    }

    public MappingReferences getMappingReferences() {
        return this.mappingReferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForgedMethod that = (ForgedMethod)o;
        if (!Objects.equals(this.parameters, that.parameters)) {
            return false;
        }
        return Objects.equals(this.returnType, that.returnType);
    }

    public int hashCode() {
        int result = this.parameters != null ? this.parameters.hashCode() : 0;
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        return result;
    }
}

