/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.reader;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.jxls.reader.OffsetCellCheck;
import org.jxls.reader.OffsetRowCheck;
import org.jxls.reader.XLSRowCursor;

public class OffsetRowCheckImpl
implements OffsetRowCheck {
    List<OffsetCellCheck> cellChecks = new ArrayList<OffsetCellCheck>();
    int offset;

    public OffsetRowCheckImpl() {
    }

    public OffsetRowCheckImpl(int offset) {
        this.offset = offset;
    }

    public OffsetRowCheckImpl(List<OffsetCellCheck> cellChecks) {
        this.cellChecks = cellChecks;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    public List getCellChecks() {
        return this.cellChecks;
    }

    public void setCellChecks(List<OffsetCellCheck> cellChecks) {
        this.cellChecks = cellChecks;
    }

    @Override
    public boolean isCheckSuccessful(Row row) {
        if (this.cellChecks.isEmpty()) {
            return this.isRowEmpty(row);
        }
        for (OffsetCellCheck offsetCellCheck : this.cellChecks) {
            if (offsetCellCheck.isCheckSuccessful(row)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCheckSuccessful(XLSRowCursor cursor) {
        if (!cursor.hasNext()) {
            return this.isCellChecksEmpty();
        }
        Row row = cursor.getSheet().getRow(this.offset + cursor.getCurrentRowNum());
        if (row == null) {
            return this.isCellChecksEmpty();
        }
        return this.isCheckSuccessful(row);
    }

    private boolean isCellChecksEmpty() {
        if (this.cellChecks.isEmpty()) {
            return true;
        }
        for (OffsetCellCheck offsetCellCheck : this.cellChecks) {
            if (this.isCellCheckEmpty(offsetCellCheck)) continue;
            return false;
        }
        return true;
    }

    private boolean isCellCheckEmpty(OffsetCellCheck cellCheck) {
        if (cellCheck.getValue() == null) {
            return true;
        }
        return cellCheck.getValue().toString().trim().equals("");
    }

    @Override
    public void addCellCheck(OffsetCellCheck cellCheck) {
        this.cellChecks.add(cellCheck);
    }

    private boolean isRowEmpty(Row row) {
        if (row == null) {
            return true;
        }
        if (row.getLastCellNum() < 0) {
            return true;
        }
        for (short i = row.getFirstCellNum(); i <= row.getLastCellNum(); i = (short)(i + 1)) {
            Cell cell = row.getCell((int)i);
            if (this.isCellEmpty(cell)) continue;
            return false;
        }
        return true;
    }

    private boolean isCellEmpty(Cell cell) {
        if (cell == null) {
            return true;
        }
        switch (cell.getCellType()) {
            case BLANK: {
                return true;
            }
            case STRING: {
                String cellValue = cell.getRichStringCellValue().getString();
                return cellValue == null || cellValue.length() == 0 || cellValue.trim().length() == 0;
            }
        }
        return false;
    }
}

