/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.event;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import org.jsr107.ri.event.RICacheEntryEventFilteringIterable;
import org.jsr107.ri.event.RICacheEntryListenerRegistration;

public class RICacheEventDispatcher<K, V> {
    private ConcurrentHashMap<Class<? extends CacheEntryListener>, ArrayList<CacheEntryEvent<K, V>>> eventMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Class<? extends CacheEntryListener> listenerClass, CacheEntryEvent<K, V> event) {
        ArrayList<Object> eventList;
        if (listenerClass == null) {
            throw new NullPointerException("listenerClass can't be null");
        }
        if (event == null) {
            throw new NullPointerException("event can't be null");
        }
        if (!listenerClass.isInterface() || !CacheEntryListener.class.isAssignableFrom(listenerClass)) {
            throw new IllegalArgumentException("listenerClass must be an CacheEntryListener interface");
        }
        RICacheEventDispatcher rICacheEventDispatcher = this;
        synchronized (rICacheEventDispatcher) {
            eventList = this.eventMap.get(listenerClass);
            if (eventList == null) {
                eventList = new ArrayList();
                this.eventMap.put(listenerClass, eventList);
            }
        }
        eventList.add(event);
    }

    public void dispatch(Iterable<RICacheEntryListenerRegistration<K, V>> registrations) {
        try {
            CacheEntryListener<K, V> listener;
            Iterable iterable;
            CacheEntryEventFilter<K, V> filter;
            Iterable events = this.eventMap.get(CacheEntryExpiredListener.class);
            if (events != null) {
                for (RICacheEntryListenerRegistration<K, V> registration : registrations) {
                    filter = registration.getCacheEntryFilter();
                    Iterable iterable2 = iterable = filter == null ? events : new RICacheEntryEventFilteringIterable<K, V>(events, filter);
                    listener = registration.getCacheEntryListener();
                    if (!(listener instanceof CacheEntryExpiredListener)) continue;
                    ((CacheEntryExpiredListener)listener).onExpired(iterable);
                }
            }
            if ((events = (Iterable)this.eventMap.get(CacheEntryCreatedListener.class)) != null) {
                for (RICacheEntryListenerRegistration<K, V> registration : registrations) {
                    filter = registration.getCacheEntryFilter();
                    Iterable iterable3 = iterable = filter == null ? events : new RICacheEntryEventFilteringIterable<K, V>(events, filter);
                    listener = registration.getCacheEntryListener();
                    if (!(listener instanceof CacheEntryCreatedListener)) continue;
                    ((CacheEntryCreatedListener)listener).onCreated(iterable);
                }
            }
            if ((events = (Iterable)this.eventMap.get(CacheEntryUpdatedListener.class)) != null) {
                for (RICacheEntryListenerRegistration<K, V> registration : registrations) {
                    filter = registration.getCacheEntryFilter();
                    Iterable iterable4 = iterable = filter == null ? events : new RICacheEntryEventFilteringIterable<K, V>(events, filter);
                    listener = registration.getCacheEntryListener();
                    if (!(listener instanceof CacheEntryUpdatedListener)) continue;
                    ((CacheEntryUpdatedListener)listener).onUpdated(iterable);
                }
            }
            if ((events = (Iterable)this.eventMap.get(CacheEntryRemovedListener.class)) != null) {
                for (RICacheEntryListenerRegistration<K, V> registration : registrations) {
                    filter = registration.getCacheEntryFilter();
                    Iterable iterable5 = iterable = filter == null ? events : new RICacheEntryEventFilteringIterable<K, V>(events, filter);
                    listener = registration.getCacheEntryListener();
                    if (!(listener instanceof CacheEntryRemovedListener)) continue;
                    ((CacheEntryRemovedListener)listener).onRemoved(iterable);
                }
            }
        }
        catch (Exception e) {
            if (!(e instanceof CacheEntryListenerException)) {
                throw new CacheEntryListenerException("Exception on listener execution", (Throwable)e);
            }
            throw e;
        }
    }
}

