/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.event;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;

public class RICacheEntryEventFilteringIterator<K, V>
implements Iterator<CacheEntryEvent<K, V>> {
    private Iterator<CacheEntryEvent<K, V>> iterator;
    private CacheEntryEventFilter<? super K, ? super V> filter;
    private CacheEntryEvent<K, V> nextEntry;

    public RICacheEntryEventFilteringIterator(Iterator<CacheEntryEvent<K, V>> iterator, CacheEntryEventFilter<? super K, ? super V> filter) {
        this.iterator = iterator;
        this.filter = filter;
        this.nextEntry = null;
    }

    private void fetch() {
        while (this.nextEntry == null && this.iterator.hasNext()) {
            CacheEntryEvent<K, V> entry = this.iterator.next();
            if (!this.filter.evaluate(entry)) continue;
            this.nextEntry = entry;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextEntry == null) {
            this.fetch();
        }
        return this.nextEntry != null;
    }

    @Override
    public CacheEntryEvent<K, V> next() {
        if (this.hasNext()) {
            CacheEntryEvent<K, V> entry = this.nextEntry;
            this.nextEntry = null;
            return entry;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this.iterator.remove();
        this.nextEntry = null;
    }
}

