/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.event;

import javax.cache.Cache;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.EventType;

public class RICacheEntryEvent<K, V>
extends CacheEntryEvent<K, V> {
    private K key;
    private V value;
    private V oldValue;
    private boolean oldValueAvailable;

    public RICacheEntryEvent(Cache<K, V> source, K key, V value, EventType eventType) {
        super(source, eventType);
        this.key = key;
        this.value = value;
        this.oldValue = null;
        this.oldValueAvailable = false;
    }

    public RICacheEntryEvent(Cache<K, V> source, K key, V value, V oldValue, EventType eventType) {
        super(source, eventType);
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
        this.oldValueAvailable = true;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public V getOldValue() throws UnsupportedOperationException {
        if (this.isOldValueAvailable()) {
            return this.oldValue;
        }
        throw new UnsupportedOperationException("Old value is not available for key");
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz != null && clazz.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        throw new IllegalArgumentException("The class " + clazz + " is unknown to this implementation");
    }

    public boolean isOldValueAvailable() {
        return this.oldValueAvailable;
    }
}

