/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import javax.cache.CacheException;
import org.jsr107.ri.RIInternalConverter;

class RISerializingInternalConverter<T>
implements RIInternalConverter<T> {
    private WeakReference<ClassLoader> classLoaderReference;

    public RISerializingInternalConverter(ClassLoader classLoader) {
        this.classLoaderReference = new WeakReference<ClassLoader>(classLoader);
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoaderReference.get();
    }

    @Override
    public Object toInternal(T value) {
        return new Serialized<T>(value);
    }

    @Override
    public T fromInternal(Object internal) {
        if (internal == null) {
            return null;
        }
        if (internal instanceof Serialized) {
            return (T)((Serialized)internal).deserialize(this.getClassLoader());
        }
        throw new IllegalArgumentException("internal value is not a Serialized instance [" + internal + "]");
    }

    private static final class CustomizedClassLoaderObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classloader;

        private CustomizedClassLoaderObjectInputStream(InputStream in, ClassLoader classloader) throws IOException {
            super(in);
            this.classloader = classloader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            try {
                return Class.forName(name, false, this.classloader);
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }
    }

    private static class Serialized<V> {
        private final byte[] bytes;
        private final int hashCode;

        Serialized(V value) {
            if (value == null) {
                this.hashCode = 0;
                this.bytes = null;
            } else {
                this.hashCode = value.hashCode();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(value);
                    bos.flush();
                    this.bytes = bos.toByteArray();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to serialize: " + value + " due to " + e.getMessage(), e);
                }
                finally {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        public V deserialize(ClassLoader classLoader) {
            Object object;
            ByteArrayInputStream bos = new ByteArrayInputStream(this.bytes);
            try {
                CustomizedClassLoaderObjectInputStream ois = new CustomizedClassLoaderObjectInputStream(bos, classLoader);
                object = ois.readObject();
            }
            catch (IOException e) {
                throw new CacheException("Failed to deserialize: " + e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new CacheException("Failed to resolve a deserialized class: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    bos.close();
                }
                catch (IOException e) {}
            }
            return (V)object;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof Serialized)) {
                return false;
            }
            Serialized serialized = (Serialized)object;
            if (!Arrays.equals(this.bytes, serialized.bytes)) {
                return false;
            }
            return this.hashCode == serialized.hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

