/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.spring.jpa;

import java.util.function.Supplier;
import javax.persistence.AttributeConverter;
import org.jmolecules.ddd.types.AggregateRoot;
import org.jmolecules.ddd.types.Association;
import org.jmolecules.ddd.types.Identifier;
import org.jmolecules.spring.AssociationToPrimitivesConverter;
import org.jmolecules.spring.PrimitivesToAssociationConverter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.Assert;

public class AssociationAttributeConverter<T extends AggregateRoot<T, ID>, ID extends Identifier, S>
implements AttributeConverter<Association<T, ID>, S> {
    private static ConversionService CONVERSION_SERVICE = DefaultConversionService.getSharedInstance();
    private static TypeDescriptor OBJECT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Object.class);
    private final PrimitivesToAssociationConverter<?> toAssociation;
    private final AssociationToPrimitivesConverter<?> toPrimitive;
    private final TypeDescriptor idTypeDescriptor;

    protected AssociationAttributeConverter(Class<ID> itType) {
        Assert.notNull(itType, (String)"Identifier type must not be null!");
        Supplier<ConversionService> conversionService = () -> CONVERSION_SERVICE;
        this.toAssociation = new PrimitivesToAssociationConverter(conversionService);
        this.toPrimitive = new AssociationToPrimitivesConverter(conversionService);
        ResolvableType associationType = ResolvableType.forClassWithGenerics(Association.class, (Class[])new Class[]{Object.class, itType});
        this.idTypeDescriptor = new TypeDescriptor(associationType, null, null);
    }

    public S convertToDatabaseColumn(Association<T, ID> attribute) {
        return (S)this.toPrimitive.convert(attribute, TypeDescriptor.forObject(attribute), OBJECT_TYPE_DESCRIPTOR);
    }

    public Association<T, ID> convertToEntityAttribute(S dbData) {
        return (Association)this.toAssociation.convert(dbData, TypeDescriptor.forObject(dbData), this.idTypeDescriptor);
    }
}

