/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.spring;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.jmolecules.ddd.types.AggregateRoot;
import org.jmolecules.ddd.types.Association;
import org.jmolecules.ddd.types.Identifier;
import org.jmolecules.spring.IdentifierToPrimitivesConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AssociationToPrimitivesConverter<T extends AggregateRoot<T, Identifier>>
implements GenericConverter {
    private static final TypeDescriptor OBJECT_DESCRIPTOR = TypeDescriptor.valueOf(Object.class);
    private static final TypeDescriptor IDENTIFIER_DESCRIPTOR = TypeDescriptor.valueOf(Identifier.class);
    private final IdentifierToPrimitivesConverter delegate;

    public AssociationToPrimitivesConverter(Supplier<? extends ConversionService> conversionService) {
        this(new IdentifierToPrimitivesConverter(conversionService));
    }

    public AssociationToPrimitivesConverter(IdentifierToPrimitivesConverter delegate) {
        Assert.notNull((Object)delegate, (String)"IdentifierToPrimitivesConverter must not be null!");
        this.delegate = delegate;
    }

    @NonNull
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Association.class, Object.class));
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        Identifier identifier = (Identifier)((Association)source).getId();
        if (identifier == null) {
            throw new IllegalStateException(String.format("Association target identifier must not be null for %s!", source.getClass().getSimpleName()));
        }
        if (targetType.isAssignableTo(IDENTIFIER_DESCRIPTOR) && TypeDescriptor.forObject((Object)identifier).isAssignableTo(targetType)) {
            return identifier;
        }
        return this.delegate.convert(identifier, TypeDescriptor.valueOf(identifier.getClass()), OBJECT_DESCRIPTOR);
    }
}

