/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.sqlparser.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.minidao.sqlparser.AbstractSqlProcessor;
import org.jeecgframework.minidao.sqlparser.impl.vo.SelectSqlInfo;
import org.jeecgframework.minidao.util.MiniDaoUtil;

public class SimpleSqlProcessor
implements AbstractSqlProcessor {
    private static final String SQLSERVER_SQL = "select * from ( select row_number() over(order by tempColumn) tempRowNumber, * from (select top {1} tempColumn = 0, {0}) t ) tt where tempRowNumber > {2}";
    private static final List<String> ORDER_DIRECTION = Arrays.asList("ASC", "DESC");

    @Override
    public String getSqlServerPageSql(String sql, MiniDaoPage miniDaoPage) {
        int page = miniDaoPage.getPage();
        int rows = miniDaoPage.getRows();
        Object[] sqlParam = new String[3];
        sql = MiniDaoUtil.removeOrderBy(sql);
        int beginIndex = (page - 1) * rows;
        int endIndex = beginIndex + rows;
        sqlParam[2] = Integer.toString(beginIndex);
        sqlParam[1] = Integer.toString(endIndex);
        sqlParam[0] = sql.substring(SimpleSqlProcessor.getAfterSelectInsertPoint(sql));
        sql = MessageFormat.format(SQLSERVER_SQL, sqlParam);
        return sql;
    }

    @Override
    public String getCountSql(String sql) {
        sql = MiniDaoUtil.removeOrderBy(sql);
        return "select count(0) from (" + sql + ") tmp_count";
    }

    @Override
    public String removeOrderBy(String sql) {
        if (sql == null) {
            return null;
        }
        sql = sql.replaceAll("(?i)\\s+ORDER\\s+BY\\s+[\\w\\s,.]+", "");
        return sql;
    }

    @Override
    public List<Map<String, Object>> parseSqlFields(String parsedSql) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ArrayList<String> fields = new ArrayList<String>();
        Pattern pattern = Pattern.compile("SELECT\\s+(.*?)\\s+FROM", 2);
        Matcher matcher = pattern.matcher(parsedSql);
        if (matcher.find()) {
            String[] fieldArray;
            String selectFields = matcher.group(1);
            for (String field : fieldArray = selectFields.split(",")) {
                fields.add(field.trim());
            }
        }
        return list;
    }

    @Override
    public String addOrderBy(String sql, String field, boolean isAsc) {
        int orderByIndex = SimpleSqlProcessor.findOuterOrderBy(sql);
        field = field.trim().toLowerCase();
        String orderField = " " + field + " " + (isAsc ? "ASC" : "DESC") + " ";
        if (orderByIndex != -1) {
            String[] existingOrderByFields;
            String existingOrderByClause = sql.substring(orderByIndex + 8).trim().toLowerCase();
            String replaceReg = "\\s*[,;\\s]\\s*";
            for (String existingOrderByField : existingOrderByFields = existingOrderByClause.split(replaceReg)) {
                if (null == existingOrderByField || ORDER_DIRECTION.contains(existingOrderByField.trim()) || !existingOrderByField.equalsIgnoreCase(field)) continue;
                return sql;
            }
            return sql.substring(0, orderByIndex + 8) + " " + orderField + ", " + sql.substring(orderByIndex + 8);
        }
        if (sql.trim().endsWith(";")) {
            sql = sql.substring(0, sql.lastIndexOf(";"));
        }
        return sql.trim() + " ORDER BY " + orderField;
    }

    private static int findOuterOrderBy(String sql) {
        int nestedLevel = 0;
        int orderByIndex = -1;
        String lowerSql = sql.toLowerCase();
        for (int i = 0; i < lowerSql.length(); ++i) {
            char c = lowerSql.charAt(i);
            if (c == '(') {
                ++nestedLevel;
                continue;
            }
            if (c == ')') {
                --nestedLevel;
                continue;
            }
            if (nestedLevel != 0 || !lowerSql.startsWith("order by", i)) continue;
            orderByIndex = i;
            break;
        }
        return orderByIndex;
    }

    private static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
    }

    @Override
    public Map<String, SelectSqlInfo> parseAllSelectTable(String selectSql) {
        HashMap<String, SelectSqlInfo> tableMap = new HashMap<String, SelectSqlInfo>();
        String regex = "(?i)\\b(from|join)\\s+([\\w.]+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(selectSql);
        while (matcher.find()) {
            String tableName = matcher.group(2);
            SelectSqlInfo selectSqlInfo = new SelectSqlInfo(selectSql);
            selectSqlInfo.setFromTableName(tableName);
            tableMap.put(tableName, selectSqlInfo);
        }
        return tableMap;
    }

    @Override
    public SelectSqlInfo parseSelectSqlInfo(String selectSql) {
        System.err.println("\u6b64\u65b9\u6cd5\u672a\u5b9e\u73b0\uff01\uff01\uff01");
        return null;
    }
}

