/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.dispatcher.core.ConnectionMangerV2;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.TraceLogger;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.logging.Level;

public class VisibleBufferedInputStream
extends InputStream {
    private static final int MINIMUM_READ = 1024;
    private static final int STRING_SCAN_SPAN = 1024;
    private final InputStream wrappedInputStream;
    private byte[] _buffer;
    private int _index;
    private int endIndex;
    private String _host;
    private boolean useDispatch;
    private int _version;
    private int socketTimeout;
    public ConnectionMangerV2 pCMV2;

    public VisibleBufferedInputStream(InputStream in, int _bufferSize, String _host, boolean useDispatch, int _version, Object cCMV2) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.wrappedInputStream = in;
        this._buffer = new byte[_bufferSize < 1024 ? 1024 : _bufferSize];
        this._host = _host;
        this.useDispatch = useDispatch;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._version = _version;
        this.pCMV2 = (ConnectionMangerV2)cCMV2;
    }

    @Override
    public int read() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.ensureBytes(1)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this._buffer[this._index++] & 0xFF;
        }
        return -1;
    }

    public int peek() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean k = true;
        int m = -1;
        if (this.ensureBytes(1)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this._buffer[this._index] & 0xFF;
        }
        return -1;
    }

    public byte readRaw() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._buffer[this._index++];
    }

    public boolean ensureBytes(int n) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int required = n - this.endIndex + this._index;
        while (required > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!this.readMore(required)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
            required = n - this.endIndex + this._index;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readMore(int wanted) throws IOException {
        int canFit;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.endIndex == this._index) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._index = 0;
            this.endIndex = 0;
        }
        if ((canFit = this._buffer.length - this.endIndex) < wanted) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this._index + canFit > wanted + 1024) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.compact();
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.doubleBuffer();
            }
            canFit = this._buffer.length - this.endIndex;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int readT = -1;
        int i = 0;
        int j = 0;
        while (true) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                readT = this.wrappedInputStream.read(this._buffer, this.endIndex, canFit);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.useDispatch) {
                    if ((this.pCMV2.master_online_ip.equals(this._host) || this.pCMV2.slave_online_ip.contains(this._host + ",")) && this.pCMV2._connVersion.get(this._host) == this._version && (this.socketTimeout == 0 || ++i < this.socketTimeout)) {
                        if (++j % 5 != 0) continue;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.INFO, "Online _host {0} has been waiting for {1} times, socketTimeout is {2}", this._host, j, this.socketTimeout);
                        continue;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBLOGGER.log(Level.INFO, "socketTimeout Exception: useDispatch is true, and _host = [" + this._host + "], master_online_ip = [" + this.pCMV2.master_online_ip + "], slave_online_ip = [" + this.pCMV2.slave_online_ip + "], currentVersion = [" + this.pCMV2._connVersion.get(this._host) + "], lastVersion = [" + this._version + "], socketTimeout = [" + this.socketTimeout + "]", new Object[0]);
                    Map<String, Integer> map = this.pCMV2._connVersion;
                    synchronized (map) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (this._version >= this.pCMV2._connVersion.get(this._host)) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.pCMV2._connVersion.put(this._host, this.pCMV2._connVersion.get(this._host) + 1);
                        }
                    }
                }
                KBLOGGER.log(Level.INFO, "socketTimeout Exception: useDispatch is " + this.useDispatch, new Object[0]);
                throw socketTimeoutException;
            }
            break;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (readT < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        this.endIndex += readT;
        return true;
    }

    public void setSocketTimeout(int socketTimeout) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.socketTimeout = socketTimeout;
    }

    private void doubleBuffer() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] _buf = new byte[this._buffer.length * 2];
        this.moveBufferTo(_buf);
        this._buffer = _buf;
    }

    private void compact() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.moveBufferTo(this._buffer);
    }

    private void moveBufferTo(byte[] dest) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int size = this.endIndex - this._index;
        System.arraycopy(this._buffer, this._index, dest, 0, size);
        this._index = 0;
        this.endIndex = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] toBytes, int offIndex, int leng) throws IOException {
        int rd;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ((offIndex | leng | offIndex + leng | toBytes.length - (offIndex + leng)) < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IndexOutOfBoundsException();
        }
        if (leng == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int avail = this.endIndex - this._index;
        if (leng - avail < 1024) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.ensureBytes(leng);
            avail = this.endIndex - this._index;
        }
        if (avail > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (leng <= avail) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                System.arraycopy(this._buffer, this._index, toBytes, offIndex, leng);
                this._index += leng;
                return leng;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            System.arraycopy(this._buffer, this._index, toBytes, offIndex, avail);
            leng -= avail;
            offIndex += avail;
        }
        int readT = avail;
        this._index = 0;
        this.endIndex = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        do {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            rd = -1;
            int i = 0;
            int j = 0;
            while (true) {
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    rd = this.wrappedInputStream.read(toBytes, offIndex, leng);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (this.useDispatch) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if ((this.pCMV2.master_online_ip.equals(this._host) || this.pCMV2.slave_online_ip.contains(this._host + ",")) && this.pCMV2._connVersion.get(this._host) == this._version && (this.socketTimeout == 0 || ++i < this.socketTimeout)) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (++j % 5 != 0) continue;
                            KBLOGGER.log(Level.INFO, "Online _host {0} has been waiting for {1} times, socketTimeout is {2}", this._host, j, this.socketTimeout);
                            continue;
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.INFO, "socketTimeout Exception: useDispatch is true, and _host = [" + this._host + "], master_online_ip = [" + this.pCMV2.master_online_ip + "], slave_online_ip = [" + this.pCMV2.slave_online_ip + "], currentVersion = [" + this.pCMV2._connVersion.get(this._host) + "], lastVersion = [" + this._version + "], socketTimeout = [" + this.socketTimeout + "]", new Object[0]);
                        Map<String, Integer> map = this.pCMV2._connVersion;
                        synchronized (map) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (this._version >= this.pCMV2._connVersion.get(this._host)) {
                                this.pCMV2._connVersion.put(this._host, this.pCMV2._connVersion.get(this._host) + 1);
                            }
                        }
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.INFO, "socketTimeout Exception: useDispatch is " + this.useDispatch, new Object[0]);
                    }
                    throw socketTimeoutException;
                }
                break;
            }
            if (rd <= 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 0 == readT ? rd : readT;
            }
            readT += rd;
            offIndex += rd;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } while ((leng -= rd) > 0);
        return readT;
    }

    @Override
    public long skip(long n) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int avail = this.endIndex - this._index;
        if ((long)avail >= n) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._index = (int)((long)this._index + n);
            return n;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._index = 0;
        this.endIndex = 0;
        return (long)avail + this.wrappedInputStream.skip(n -= (long)avail);
    }

    @Override
    public int available() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int avail = this.endIndex - this._index;
        return avail > 0 ? avail : this.wrappedInputStream.available();
    }

    @Override
    public void close() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.wrappedInputStream.close();
    }

    public byte[] getBuffer() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._buffer;
    }

    public int getIndex() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._index;
    }

    public int scanCStringLength() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int position = this._index;
        while (true) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (position < this.endIndex) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this._buffer[position++] != 0) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return position - this._index;
            }
            if (!this.readMore(1024)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new EOFException();
            }
            position = this._index;
        }
    }
}

