/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;

class BootstrapStats {
    private final EnumMap<EventType, AtomicLong> counts = new EnumMap(EventType.class);

    BootstrapStats() {
    }

    void increment(EventType evenType) {
        AtomicLong count = this.counts.get((Object)evenType);
        if (count != null) {
            count.incrementAndGet();
        } else {
            this.counts.put(evenType, new AtomicLong(1L));
        }
    }

    EnumMap<EventType, AtomicLong> getCounts() {
        return this.counts;
    }

    static enum EventType {
        PAT(ProcessAnnotatedType.class, 1),
        PP(ProcessProducer.class, 6),
        PB(ProcessBean.class, 5),
        PIP(ProcessInjectionPoint.class, 2),
        PIT(ProcessInjectionTarget.class, 3),
        PBA(ProcessBeanAttributes.class, 4),
        POM(ProcessObserverMethod.class, 7);

        private Class<?> eventType;
        private int priority;

        private EventType(Class<?> eventType, int priority) {
            this.eventType = eventType;
            this.priority = priority;
        }

        String getType() {
            return this.eventType.getName();
        }

        int getPriority() {
            return this.priority;
        }
    }
}

