/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.pom;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

public class ParsedPomFileImpl
implements ParsedPomFile {
    private final Model model;
    private final ArtifactTypeRegistry registry;

    public ParsedPomFileImpl(Model model, ArtifactTypeRegistry registry) {
        Validate.notNull(model, "Maven Project Object Model must not be null");
        Validate.notNull(registry, "Artifact Type Registry must not be null");
        this.model = model;
        this.registry = registry;
    }

    public String getGroupId() {
        return this.model.getGroupId();
    }

    public String getArtifactId() {
        return this.model.getArtifactId();
    }

    public String getVersion() {
        return this.model.getVersion();
    }

    public String getName() {
        return this.model.getName();
    }

    public Model getModel() {
        return this.model;
    }

    public String getOrganizationName() {
        return this.model.getOrganization() != null ? this.model.getOrganization().getName() : null;
    }

    public URL getOrganizationUrl() {
        if (this.model.getOrganization() == null) {
            return null;
        }
        String url = this.model.getOrganization().getUrl();
        if (Validate.isNullOrEmpty(url)) {
            return null;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(url + " does not represent a valid URL, unable to get Organization URL from the POM file");
        }
    }

    public String getFinalName() {
        return this.model.getBuild().getFinalName() + "." + this.model.getPackaging();
    }

    public PackagingType getPackagingType() {
        return PackagingType.of((String)this.model.getPackaging());
    }

    public File getBaseDirectory() {
        return this.model.getProjectDirectory();
    }

    public File getSourceDirectory() {
        return new File(this.model.getBuild().getSourceDirectory());
    }

    public File getBuildOutputDirectory() {
        return new File(this.model.getBuild().getOutputDirectory());
    }

    public List<org.jboss.shrinkwrap.resolver.api.maven.pom.Resource> getResources() {
        ArrayList<org.jboss.shrinkwrap.resolver.api.maven.pom.Resource> list = new ArrayList<org.jboss.shrinkwrap.resolver.api.maven.pom.Resource>();
        List resources = this.model.getBuild().getResources();
        for (Resource res : resources) {
            File resourceDir = new File(res.getDirectory());
            if (!Validate.isReadable(resourceDir)) continue;
            String targetPrefix = res.getTargetPath();
            for (String relPath : FileUtils.listFiles(resourceDir, res.getIncludes(), res.getExcludes())) {
                list.add(new org.jboss.shrinkwrap.resolver.api.maven.pom.Resource(new File(resourceDir, relPath), this.normalizeTargetPath(targetPrefix, relPath)));
            }
        }
        return list;
    }

    public List<org.jboss.shrinkwrap.resolver.api.maven.pom.Resource> getTestResources() {
        ArrayList<org.jboss.shrinkwrap.resolver.api.maven.pom.Resource> list = new ArrayList<org.jboss.shrinkwrap.resolver.api.maven.pom.Resource>();
        List resources = this.model.getBuild().getTestResources();
        for (Resource res : resources) {
            File resourceDir = new File(res.getDirectory());
            if (!Validate.isReadable(resourceDir)) continue;
            String targetPrefix = res.getTargetPath();
            for (String relPath : FileUtils.listFiles(resourceDir, res.getIncludes(), res.getExcludes())) {
                list.add(new org.jboss.shrinkwrap.resolver.api.maven.pom.Resource(new File(resourceDir, relPath), this.normalizeTargetPath(targetPrefix, relPath)));
            }
        }
        return list;
    }

    public File getTestSourceDirectory() {
        return new File(this.model.getBuild().getTestSourceDirectory());
    }

    public File getTestOutputDirectory() {
        return new File(this.model.getBuild().getTestOutputDirectory());
    }

    public Set<MavenDependency> getDependencyManagement() {
        if (this.model.getDependencyManagement() != null) {
            Set<MavenDependency> dependencies = MavenConverter.fromDependencies(this.model.getDependencyManagement().getDependencies(), this.registry);
            return dependencies;
        }
        return Collections.emptySet();
    }

    public Set<MavenDependency> getDependencies() {
        if (this.model.getDependencies() != null) {
            return MavenConverter.fromDependencies(this.model.getDependencies(), this.registry);
        }
        return Collections.emptySet();
    }

    public Map<String, Object> getPluginConfiguration(String pluginKey) {
        Map plugins = this.model.getBuild().getPluginsAsMap();
        Plugin plugin = (Plugin)plugins.get(pluginKey);
        if (plugin == null) {
            return Collections.emptyMap();
        }
        Xpp3Dom rawConfiguration = (Xpp3Dom)plugin.getConfiguration();
        if (rawConfiguration == null) {
            return Collections.emptyMap();
        }
        return this.toMappedConfiguration(rawConfiguration);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.model.getProperties());
        return props;
    }

    private Map<String, Object> toMappedConfiguration(Xpp3Dom node) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Xpp3Dom child : node.getChildren()) {
            Object value = child.getChildCount() > 0 ? this.toMappedConfiguration(child) : child.getValue();
            if (map.containsKey(child.getName())) {
                ArrayList oldValue = map.get(child.getName());
                if (!(oldValue instanceof List)) {
                    ArrayList objects = new ArrayList();
                    objects.add(oldValue);
                    oldValue = objects;
                }
                ((List)oldValue).add(value);
                value = oldValue;
            }
            map.put(child.getName(), value);
        }
        return map;
    }

    private String normalizeTargetPath(String targetPrefix, String target) {
        StringBuilder sb = new StringBuilder();
        if (targetPrefix != null) {
            sb.append(targetPrefix);
        }
        if (targetPrefix != null && !targetPrefix.endsWith("/")) {
            targetPrefix = targetPrefix.replace('\\', '/');
            sb.append("/");
        }
        if (target != null) {
            target = target.replace('\\', '/');
            sb.append(target);
        }
        return sb.toString();
    }

    private static final class FileUtils {
        private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
        private static final String[] EMPTY_STRING_ARRAY = new String[0];

        private FileUtils() {
        }

        public static Collection<File> listFiles(File root) {
            ArrayList<File> allFiles = new ArrayList<File>();
            LinkedList<File> dirs = new LinkedList<File>();
            dirs.add(root);
            while (!dirs.isEmpty()) {
                for (File f : ((File)dirs.poll()).listFiles()) {
                    if (f.isDirectory()) {
                        allFiles.add(f);
                        dirs.add(f);
                        continue;
                    }
                    if (!f.isFile()) continue;
                    allFiles.add(f);
                }
            }
            return allFiles;
        }

        public static Collection<String> listFiles(File baseDir, List<String> includes, List<String> excludes) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(baseDir);
            if (excludes != null) {
                scanner.setExcludes(excludes.toArray(EMPTY_STRING_ARRAY));
            }
            scanner.addDefaultExcludes();
            if (includes != null && includes.size() > 0) {
                scanner.setIncludes(includes.toArray(EMPTY_STRING_ARRAY));
            } else {
                scanner.setIncludes(DEFAULT_INCLUDES);
            }
            scanner.scan();
            return Arrays.asList(scanner.getIncludedFiles());
        }
    }
}

