/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.server;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.plugin.common.Files;
import org.jboss.as.plugin.common.IoUtils;
import org.jboss.as.plugin.common.ServerOperations;
import org.jboss.as.plugin.server.Server;
import org.jboss.as.plugin.server.ServerInfo;
import org.jboss.dmr.ModelNode;

final class StandaloneServer
extends Server {
    private static final String CONFIG_PATH = "/standalone/configuration/";
    private static final String STARTING = "STARTING";
    private static final String STOPPING = "STOPPING";
    private final ServerInfo serverInfo;
    private boolean isRunning;
    private ModelControllerClient client;

    public StandaloneServer(ServerInfo serverInfo) {
        super(serverInfo, "JBAS015950");
        this.serverInfo = serverInfo;
        this.isRunning = false;
    }

    @Override
    protected void init() throws IOException {
        this.client = ModelControllerClient.Factory.create((InetAddress)this.serverInfo.getConnectionInfo().getHostAddress(), (int)this.serverInfo.getConnectionInfo().getPort(), (CallbackHandler)this.serverInfo.getConnectionInfo().getCallbackHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopServer() {
        block10: {
            try {
                if (this.client == null) break block10;
                try {
                    this.client.execute(ServerOperations.createOperation((String)"shutdown"));
                }
                catch (IOException e) {
                }
                finally {
                    IoUtils.safeClose((Closeable)this.client);
                    this.client = null;
                }
                try {
                    this.getConsole().awaitShutdown(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.isRunning = false;
            }
        }
    }

    @Override
    public synchronized boolean isRunning() {
        if (this.isRunning) {
            return this.isRunning;
        }
        this.checkServerState();
        return this.isRunning;
    }

    @Override
    public synchronized ModelControllerClient getClient() {
        return this.client;
    }

    @Override
    protected List<String> createLaunchCommand() {
        File jbossHome = this.serverInfo.getJbossHome();
        String javaHome = this.serverInfo.getJavaHome();
        File modulesJar = new File(Files.createPath(jbossHome.getAbsolutePath(), "jboss-modules.jar"));
        if (!modulesJar.exists()) {
            throw new IllegalStateException("Cannot find: " + modulesJar);
        }
        String javaExec = Files.createPath(javaHome, "bin", "java");
        if (javaHome.contains(" ")) {
            javaExec = "\"" + javaExec + "\"";
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(javaExec);
        if (this.serverInfo.getJvmArgs() != null) {
            Collections.addAll(cmd, this.serverInfo.getJvmArgs());
        }
        cmd.add("-Djboss.home.dir=" + jbossHome);
        cmd.add("-Dorg.jboss.boot.log.file=" + jbossHome + "/standalone/log/boot.log");
        cmd.add("-Dlogging.configuration=file:" + jbossHome + CONFIG_PATH + "logging.properties");
        cmd.add("-Djboss.modules.dir=" + this.serverInfo.getModulesDir().getAbsolutePath());
        cmd.add("-Djboss.bundles.dir=" + this.serverInfo.getBundlesDir().getAbsolutePath());
        cmd.add("-jar");
        cmd.add(modulesJar.getAbsolutePath());
        cmd.add("-mp");
        cmd.add(this.serverInfo.getModulesDir().getAbsolutePath());
        cmd.add("-jaxpmodule");
        cmd.add("javax.xml.jaxp-provider");
        cmd.add("org.jboss.as.standalone");
        if (this.serverInfo.getServerConfig() != null) {
            cmd.add("-server-config");
            cmd.add(this.serverInfo.getServerConfig());
        }
        if (this.serverInfo.getPropertiesFile() != null) {
            cmd.add("-P");
            cmd.add(this.serverInfo.getPropertiesFile());
        }
        return cmd;
    }

    @Override
    protected void checkServerState() {
        if (this.client == null) {
            this.isRunning = false;
        } else {
            try {
                ModelNode result = this.client.execute(ServerOperations.createReadAttributeOperation("server-state"));
                this.isRunning = ServerOperations.isSuccessfulOutcome((ModelNode)result) && !STARTING.equals(ServerOperations.readResultAsString(result)) && !STOPPING.equals(ServerOperations.readResultAsString(result));
            }
            catch (Throwable ignore) {
                this.isRunning = false;
            }
        }
    }
}

