/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.spi.configuration;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.configuration.ConfigurationMapper;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.openqa.selenium.support.How;

public class GrapheneConfiguration
implements DroneConfiguration<GrapheneConfiguration> {
    private long waitAjaxInterval = 2L;
    private long waitGuiInterval = 1L;
    private long waitModelInterval = 5L;
    private long waitGuardInterval = this.waitAjaxInterval;
    private long javascriptInstallationLimit = 5L;
    private String defaultElementLocatingStrategy = How.ID_OR_NAME.toString().toLowerCase();
    private String scheme = null;
    private String url = null;

    public How getDefaultElementLocatingStrategy() {
        return How.valueOf((String)this.defaultElementLocatingStrategy.toUpperCase());
    }

    public long getWaitAjaxInterval() {
        return this.waitAjaxInterval;
    }

    public long getWaitGuardInterval() {
        return this.waitGuardInterval;
    }

    public long getWaitGuiInterval() {
        return this.waitGuiInterval;
    }

    public long getWaitModelInterval() {
        return this.waitModelInterval;
    }

    public long getJavascriptInstallationLimit() {
        return this.javascriptInstallationLimit;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUrl() {
        return this.url;
    }

    public void validate() {
        if (this.waitAjaxInterval <= 0L) {
            throw new IllegalArgumentException("The waitAjaxInterval property has to be a positive number.");
        }
        if (this.waitGuiInterval <= 0L) {
            throw new IllegalArgumentException("The waitGuiInterval property has to be a positive number.");
        }
        if (this.waitModelInterval <= 0L) {
            throw new IllegalArgumentException("The waitModelInterval property has to be a positive number.");
        }
        if (this.waitGuardInterval <= 0L) {
            throw new IllegalArgumentException("The waitGuardInterval property has to be a positive number.");
        }
        if (this.javascriptInstallationLimit <= 0L) {
            throw new IllegalArgumentException("The javascriptInstallationLimut property has to a positive number.");
        }
        if (this.scheme != null && this.scheme.isEmpty()) {
            throw new IllegalArgumentException("The scheme property has to be a non-empty string.");
        }
        if (this.url != null && !this.canConstructURL(this.url)) {
            throw new IllegalArgumentException("The custom url you provided is not valid url address: " + this.url);
        }
        try {
            How.valueOf((String)this.defaultElementLocatingStrategy.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            String values = "";
            for (How value : How.values()) {
                values = values + value.toString().toLowerCase() + ", ";
            }
            throw new IllegalArgumentException("The defaultElementLocatingStrategy property has to be one of the: " + values + " and was: " + (this.defaultElementLocatingStrategy.length() != 0 ? this.defaultElementLocatingStrategy : "empty"), ex);
        }
    }

    public String getConfigurationName() {
        return "graphene";
    }

    public GrapheneConfiguration configure(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        return (GrapheneConfiguration)ConfigurationMapper.fromArquillianDescriptor((ArquillianDescriptor)descriptor, (DroneConfiguration)this, qualifier);
    }

    private boolean canConstructURL(String url) {
        boolean canConstruct;
        if (url == null || url.isEmpty()) {
            return false;
        }
        try {
            URL currentUrl = new URL(url);
            if (currentUrl.getProtocol() != null) {
                this.scheme = currentUrl.getProtocol();
            }
            canConstruct = true;
        }
        catch (MalformedURLException ex) {
            canConstruct = false;
        }
        return canConstruct;
    }
}

