/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.ee.embedded_1_1;

import javax.enterprise.inject.spi.BeanManager;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.ContextClassLoaderManager;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.Utils;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.WebArchiveClassLoader;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.WeldEEMockConfiguration;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.TestContainer;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.classloader.ShrinkWrapClassLoader;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.manager.api.WeldManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldEEMockContainer
implements DeployableContainer<WeldEEMockConfiguration> {
    private static final String SUFFIX_WEB_ARCHIVE = ".war";
    @Inject
    @ContainerScoped
    private InstanceProducer<WeldEEMockConfiguration> configuration;
    @Inject
    @DeploymentScoped
    private InstanceProducer<TestContainer> testContainerProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<Bootstrap> bootstrapProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<WeldManager> weldManagerProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<BeanManager> beanManagerProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<ContextClassLoaderManager> contextClassLoaderManagerProducer;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public Class<WeldEEMockConfiguration> getConfigurationClass() {
        return WeldEEMockConfiguration.class;
    }

    public void setup(WeldEEMockConfiguration configuration) {
        this.configuration.set((Object)configuration);
    }

    public void start() throws LifecycleException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        ShrinkWrapClassLoader classLoader = this.getClassLoader(archive);
        ContextClassLoaderManager classLoaderManager = new ContextClassLoaderManager(classLoader);
        classLoaderManager.enable();
        TestContainer container = new TestContainer(Utils.findArchiveId(archive), Utils.findBeansXml(archive), Utils.findBeanClasses(archive, (ClassLoader)classLoader), true);
        Bootstrap bootstrap = container.getBootstrap();
        this.contextClassLoaderManagerProducer.set((Object)classLoaderManager);
        try {
            container.startContainer();
        }
        finally {
            this.testContainerProducer.set((Object)container);
            this.bootstrapProducer.set((Object)bootstrap);
        }
        WeldManager manager = container.getBeanManager((BeanDeploymentArchive)container.getDeployment().getBeanDeploymentArchives().iterator().next());
        this.weldManagerProducer.set((Object)manager);
        this.beanManagerProducer.set((Object)manager);
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        TestContainer container = (TestContainer)this.testContainerProducer.get();
        if (container != null) {
            container.stopContainer();
        }
        ContextClassLoaderManager classLoaderManager = (ContextClassLoaderManager)this.contextClassLoaderManagerProducer.get();
        classLoaderManager.disable();
    }

    public void stop() throws LifecycleException {
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Weld EE Container does not support deployment of Descriptors");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Weld EE Container does not support undeployment of Descriptors");
    }

    private ShrinkWrapClassLoader getClassLoader(Archive<?> archive) {
        return archive.getName().endsWith(SUFFIX_WEB_ARCHIVE) ? new WebArchiveClassLoader(archive.getClass().getClassLoader(), archive) : new ShrinkWrapClassLoader(archive.getClass().getClassLoader(), new Archive[]{archive});
    }
}

