/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.spi.client.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentTargetDescription;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.shrinkwrap.api.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentScenario {
    private final List<Deployment> deployments = new ArrayList<Deployment>();

    public DeploymentScenario addDeployment(DeploymentDescription deployment) {
        Validate.notNull(deployment, "Deployment must be specified");
        this.validateNotSameNameAndTypeOfDeployment(deployment);
        this.validateNotSameArchiveAndSameTarget(deployment);
        this.deployments.add(new Deployment(deployment));
        return this;
    }

    public Set<TargetDescription> targets() {
        HashSet<TargetDescription> targets = new HashSet<TargetDescription>();
        for (Deployment dep : this.deployments) {
            targets.add(dep.getDescription().getTarget());
        }
        return targets;
    }

    public Set<ProtocolDescription> protocols() {
        HashSet<ProtocolDescription> protocols = new HashSet<ProtocolDescription>();
        for (Deployment dep : this.deployments) {
            protocols.add(dep.getDescription().getProtocol());
        }
        return protocols;
    }

    public Deployment deployment(DeploymentTargetDescription target) {
        Validate.notNull(target, "Target must be specified");
        if (DeploymentTargetDescription.DEFAULT.equals(target)) {
            return this.findDefaultDeployment();
        }
        return this.findMatchingDeployment(target);
    }

    public List<Deployment> managedDeploymentsInDeployOrder() {
        ArrayList<Deployment> managedDeployment = new ArrayList<Deployment>();
        for (Deployment deployment : this.deployments) {
            DeploymentDescription desc = deployment.getDescription();
            if (!desc.managed()) continue;
            managedDeployment.add(deployment);
        }
        Collections.sort(managedDeployment, new Comparator<Deployment>(){

            @Override
            public int compare(Deployment o1, Deployment o2) {
                return new Integer(o1.getDescription().getOrder()).compareTo(o2.getDescription().getOrder());
            }
        });
        return Collections.unmodifiableList(managedDeployment);
    }

    public List<Deployment> deployedDeploymentsInUnDeployOrder() {
        ArrayList<Deployment> managedDeployment = new ArrayList<Deployment>();
        for (Deployment deployment : this.deployments) {
            DeploymentDescription desc = deployment.getDescription();
            if (!desc.managed() && !deployment.isDeployed()) continue;
            managedDeployment.add(deployment);
        }
        Collections.sort(managedDeployment, new Comparator<Deployment>(){

            @Override
            public int compare(Deployment o1, Deployment o2) {
                return new Integer(o2.getDescription().getOrder()).compareTo(o1.getDescription().getOrder());
            }
        });
        return Collections.unmodifiableList(managedDeployment);
    }

    public List<Deployment> startupDeploymentsFor(TargetDescription target) {
        Validate.notNull(target, "Target must be specified");
        ArrayList<Deployment> startupDeployments = new ArrayList<Deployment>();
        for (Deployment deployment : this.deployments) {
            DeploymentDescription desc = deployment.getDescription();
            if (!desc.managed() || !target.equals(desc.getTarget())) continue;
            startupDeployments.add(deployment);
        }
        Collections.sort(startupDeployments, new Comparator<Deployment>(){

            @Override
            public int compare(Deployment o1, Deployment o2) {
                return new Integer(o1.getDescription().getOrder()).compareTo(o2.getDescription().getOrder());
            }
        });
        return Collections.unmodifiableList(startupDeployments);
    }

    public List<Deployment> deploymentsInError() {
        ArrayList<Deployment> result = new ArrayList<Deployment>();
        for (Deployment dep : this.deployments) {
            if (!dep.hasDeploymentError()) continue;
            result.add(dep);
        }
        return result;
    }

    public List<Deployment> deployedDeployments() {
        ArrayList<Deployment> result = new ArrayList<Deployment>();
        for (Deployment dep : this.deployments) {
            if (!dep.isDeployed()) continue;
            result.add(dep);
        }
        return result;
    }

    public List<Deployment> deployments() {
        return Collections.unmodifiableList(this.deployments);
    }

    private Deployment findDefaultDeployment() {
        if (this.deployments.size() == 1) {
            return this.deployments.get(0);
        }
        if (this.deployments.size() > 1) {
            List<Deployment> archiveDeployments = this.archiveDeployments(this.deployments);
            if (archiveDeployments.size() == 1) {
                return archiveDeployments.get(0);
            }
            List<Deployment> managedDeployments = this.managedDeployments(this.deployments);
            if (managedDeployments.size() == 1) {
                return managedDeployments.get(0);
            }
            List<Deployment> defaultDeployments = this.defaultDeployments(this.deployments);
            if (defaultDeployments.size() == 1) {
                return defaultDeployments.get(0);
            }
            if (defaultDeployments.size() > 1) {
                List<Deployment> defaultArchiveDeployments = this.archiveDeployments(defaultDeployments);
                return defaultArchiveDeployments.get(0);
            }
        }
        return null;
    }

    private List<Deployment> managedDeployments(List<Deployment> deployments) {
        ArrayList<Deployment> managed = new ArrayList<Deployment>();
        for (Deployment deployment : deployments) {
            if (!deployment.getDescription().managed()) continue;
            managed.add(deployment);
        }
        return managed;
    }

    private List<Deployment> defaultDeployments(List<Deployment> deployments) {
        ArrayList<Deployment> defaults = new ArrayList<Deployment>();
        for (Deployment deployment : deployments) {
            if (!deployment.getDescription().getName().equals(DeploymentTargetDescription.DEFAULT.getName())) continue;
            defaults.add(deployment);
        }
        return defaults;
    }

    private List<Deployment> archiveDeployments(List<Deployment> deployments) {
        ArrayList<Deployment> archives = new ArrayList<Deployment>();
        for (Deployment deployment : deployments) {
            if (!deployment.getDescription().isArchiveDeployment()) continue;
            archives.add(deployment);
        }
        return archives;
    }

    private Deployment findMatchingDeployment(DeploymentTargetDescription target) {
        List<Deployment> matching = this.findMatchingDeployments(target);
        if (matching.size() == 0) {
            return null;
        }
        if (matching.size() == 1) {
            return matching.get(0);
        }
        return this.archiveDeployments(matching).get(0);
    }

    private List<Deployment> findMatchingDeployments(DeploymentTargetDescription target) {
        ArrayList<Deployment> matching = new ArrayList<Deployment>();
        for (Deployment deployment : this.deployments) {
            if (!deployment.getDescription().getName().equals(target.getName())) continue;
            matching.add(deployment);
        }
        return matching;
    }

    private void validateNotSameNameAndTypeOfDeployment(DeploymentDescription deployment) {
        for (Deployment existing : this.deployments) {
            if (!existing.getDescription().getName().equals(deployment.getName()) || (!existing.getDescription().isArchiveDeployment() || !deployment.isArchiveDeployment()) && (!existing.getDescription().isDescriptorDeployment() || !deployment.isDescriptorDeployment())) continue;
            throw new IllegalArgumentException("Can not add multiple " + Archive.class.getName() + " deployments with the same name: " + deployment.getName());
        }
    }

    private void validateNotSameArchiveAndSameTarget(DeploymentDescription deployment) {
        if (!deployment.isArchiveDeployment()) {
            return;
        }
        for (Deployment existing : this.archiveDeployments(this.deployments)) {
            if (!existing.getDescription().getArchive().getName().equals(deployment.getArchive().getName()) || !existing.getDescription().getTarget().equals(deployment.getTarget())) continue;
            throw new IllegalArgumentException("Can not add multiple " + Archive.class.getName() + " archive deployments with the same archive name " + deployment.getName() + " that target the same target " + deployment.getTarget());
        }
    }
}

