/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.i18n.translate;

import com.memetix.mst.MicrosoftTranslatorAPI;
import com.memetix.mst.language.Language;
import com.memetix.mst.translate.Translate;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BingAutoTranslationService {
    protected final Log log = LogFactory.getLog(this.getClass());
    private String clientId;
    private String clientSecret;

    public Map<String, String> getAutoUpdatedTranslationMap(Map<String, String> mainMap, Map<String, String> targetMap, String languageKey) throws Exception {
        Set<String> missing = mainMap.keySet();
        missing.removeAll(targetMap.keySet());
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(missing);
        MicrosoftTranslatorAPI.setClientId((String)this.clientId);
        MicrosoftTranslatorAPI.setClientSecret((String)this.clientSecret);
        Locale loc = new Locale(languageKey);
        String langName = loc.getDisplayLanguage().toUpperCase(loc);
        try {
            Language lang = Language.valueOf((String)langName);
            for (String key : keys) {
                String msg = mainMap.get(key);
                this.log.info((Object)("Translating message key " + key + " for language file " + languageKey));
                String translation = Translate.execute((String)msg, (Language)lang);
                targetMap.put(key, translation);
            }
        }
        catch (IllegalArgumentException ex) {
            this.log.warn((Object)("Language " + langName + " is currently unsupported."));
        }
        return targetMap;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String sec) {
        this.clientSecret = sec;
    }
}

