/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.view;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.web.view.Cas30ResponseView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@Component(value="cas3ServiceJsonView")
public class Cas30JsonResponseView
extends Cas30ResponseView {
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Cas30JsonResponseView() {
        super((View)Cas30JsonResponseView.createDelegatedView());
        this.logger.debug("Initialized {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    private static MappingJackson2JsonView createDelegatedView() {
        MappingJackson2JsonView view = new MappingJackson2JsonView();
        view.setPrettyPrint(true);
        view.setDisableCaching(true);
        view.getObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return view;
    }

    @Override
    protected void prepareMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, CasServiceResponse> casModel = new HashMap<String, CasServiceResponse>();
        CasServiceResponse casResponse = new CasServiceResponse();
        if (this.getAssertionFrom(model) != null) {
            CasServiceResponseAuthenticationSuccess success = this.createAuthenticationSuccess(model);
            casResponse.setAuthenticationSuccess(success);
        } else {
            CasServiceResponseAuthenticationFailure failure = this.createAuthenticationFailure(model);
            casResponse.setAuthenticationFailure(failure);
        }
        casModel.put("serviceResponse", casResponse);
        model.clear();
        model.putAll(casModel);
    }

    private CasServiceResponseAuthenticationFailure createAuthenticationFailure(Map<String, Object> model) {
        CasServiceResponseAuthenticationFailure failure = new CasServiceResponseAuthenticationFailure();
        failure.setCode(this.getErrorCodeFrom(model));
        failure.setDescription(this.getErrorDescriptionFrom(model));
        return failure;
    }

    private CasServiceResponseAuthenticationSuccess createAuthenticationSuccess(Map<String, Object> model) {
        Collection chainedAuthentications;
        CasServiceResponseAuthenticationSuccess success = new CasServiceResponseAuthenticationSuccess();
        Authentication authentication = this.getPrimaryAuthenticationFrom(model);
        Principal principal = this.getPrincipal(model);
        Service service = this.getServiceFrom(model);
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        Map attributes = new HashMap(principal.getAttributes());
        this.decideIfCredentialPasswordShouldBeReleasedAsAttribute(attributes, model, registeredService);
        this.decideIfProxyGrantingTicketShouldBeReleasedAsAttribute(attributes, model, registeredService);
        attributes = this.casAttributeEncoder.encodeAttributes(attributes, this.getServiceFrom(model));
        if (!attributes.isEmpty()) {
            success.setAttributes(attributes);
        }
        success.setUser(principal.getId());
        attributes = new HashMap(authentication.getAttributes());
        this.decideIfCredentialPasswordShouldBeReleasedAsAttribute(attributes, model, registeredService);
        this.decideIfProxyGrantingTicketShouldBeReleasedAsAttribute(attributes, model, registeredService);
        attributes = this.casAttributeEncoder.encodeAttributes(attributes, this.getServiceFrom(model));
        if (!attributes.isEmpty()) {
            success.setAuthenticationAttributes(attributes);
        }
        if ((chainedAuthentications = this.getChainedAuthentications(model)) != null && !chainedAuthentications.isEmpty()) {
            ArrayList<String> proxies = new ArrayList<String>();
            for (Authentication authn : chainedAuthentications) {
                proxies.add(authn.getPrincipal().getId());
            }
            success.setProxies(proxies);
        }
        return success;
    }

    private static class CasServiceResponse {
        private CasServiceResponseAuthenticationFailure authenticationFailure;
        private CasServiceResponseAuthenticationSuccess authenticationSuccess;

        private CasServiceResponse() {
        }

        public CasServiceResponseAuthenticationFailure getAuthenticationFailure() {
            return this.authenticationFailure;
        }

        public void setAuthenticationFailure(CasServiceResponseAuthenticationFailure authenticationFailure) {
            this.authenticationFailure = authenticationFailure;
        }

        public CasServiceResponseAuthenticationSuccess getAuthenticationSuccess() {
            return this.authenticationSuccess;
        }

        public void setAuthenticationSuccess(CasServiceResponseAuthenticationSuccess authenticationSuccess) {
            this.authenticationSuccess = authenticationSuccess;
        }
    }

    private static class CasServiceResponseAuthenticationFailure {
        private String code;
        private String description;

        private CasServiceResponseAuthenticationFailure() {
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    private static class CasServiceResponseAuthenticationSuccess {
        private String user;
        private String proxyGrantingTicket;
        private List proxies;
        private Map attributes;
        private Map authenticationAttributes;

        private CasServiceResponseAuthenticationSuccess() {
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getProxyGrantingTicket() {
            return this.proxyGrantingTicket;
        }

        public void setProxyGrantingTicket(String proxyGrantingTicket) {
            this.proxyGrantingTicket = proxyGrantingTicket;
        }

        public List getProxies() {
            return this.proxies;
        }

        public void setProxies(List proxies) {
            this.proxies = proxies;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map attributes) {
            this.attributes = attributes;
        }

        public Map getAuthenticationAttributes() {
            return this.authenticationAttributes;
        }

        public void setAuthenticationAttributes(Map authenticationAttributes) {
            this.authenticationAttributes = authenticationAttributes;
        }
    }
}

