/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationServiceFactory;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.AbstractTicketException;
import org.jasig.cas.ticket.proxy.ProxyTicket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Component(value="proxyController")
@Controller
public class ProxyController {
    private static final String CONST_PROXY_FAILURE = "cas2ProxyFailureView";
    private static final String CONST_PROXY_SUCCESS = "cas2ProxySuccessView";
    private static final String MODEL_SERVICE_TICKET = "ticket";
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    private ApplicationContext context;

    @RequestMapping(path={"/proxy"}, method={RequestMethod.GET})
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        String proxyGrantingTicket = request.getParameter("pgt");
        Service targetService = ProxyController.getTargetService(request);
        if (!StringUtils.hasText((String)proxyGrantingTicket) || targetService == null) {
            return this.generateErrorView("INVALID_REQUEST", "INVALID_REQUEST_PROXY", null, request);
        }
        try {
            ProxyTicket proxyTicket = this.centralAuthenticationService.grantProxyTicket(proxyGrantingTicket, targetService);
            return new ModelAndView(CONST_PROXY_SUCCESS, MODEL_SERVICE_TICKET, (Object)proxyTicket);
        }
        catch (AbstractTicketException e) {
            return this.generateErrorView(e.getCode(), e.getCode(), new Object[]{proxyGrantingTicket}, request);
        }
        catch (UnauthorizedServiceException unauthorizedServiceException) {
            return this.generateErrorView("UNAUTHORIZED_SERVICE", "UNAUTHORIZED_SERVICE_PROXY", new Object[]{targetService}, request);
        }
    }

    private static Service getTargetService(HttpServletRequest request) {
        return new WebApplicationServiceFactory().createService(request);
    }

    private ModelAndView generateErrorView(String code, String description, Object[] args, HttpServletRequest request) {
        ModelAndView modelAndView = new ModelAndView(CONST_PROXY_FAILURE);
        modelAndView.addObject("code", (Object)code);
        modelAndView.addObject("description", (Object)StringEscapeUtils.escapeHtml4((String)this.context.getMessage(code, args, description, request.getLocale())));
        return modelAndView;
    }

    @Autowired
    public void setCentralAuthenticationService(@Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }
}

