/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationContext;
import org.jasig.cas.authentication.AuthenticationContextBuilder;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationSystemSupport;
import org.jasig.cas.authentication.AuthenticationTransaction;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.DefaultAuthenticationContextBuilder;
import org.jasig.cas.authentication.DefaultAuthenticationSystemSupport;
import org.jasig.cas.authentication.HttpBasedServiceCredential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedProxyingException;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.AbstractTicketException;
import org.jasig.cas.ticket.AbstractTicketValidationException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.proxy.ProxyGrantingTicket;
import org.jasig.cas.ticket.proxy.ProxyHandler;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.Cas20ProtocolValidationSpecification;
import org.jasig.cas.validation.ValidationResponseType;
import org.jasig.cas.validation.ValidationSpecification;
import org.jasig.cas.web.AbstractDelegateController;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;

@Component(value="serviceValidateController")
public abstract class AbstractServiceValidateController
extends AbstractDelegateController {
    public static final String DEFAULT_SERVICE_FAILURE_VIEW_NAME = "cas2ServiceFailureView";
    public static final String DEFAULT_SERVICE_SUCCESS_VIEW_NAME = "cas2ServiceSuccessView";
    public static final String DEFAULT_SERVICE_VIEW_NAME_JSON = "cas3ServiceJsonView";
    @Autowired
    private ApplicationContext context;
    @NotNull
    @Autowired(required=false)
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport = new DefaultAuthenticationSystemSupport();
    @NotNull
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @NotNull
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private Class<?> validationSpecificationClass = Cas20ProtocolValidationSpecification.class;
    @NotNull
    private ProxyHandler proxyHandler;
    @NotNull
    private String successView = "cas2ServiceSuccessView";
    @NotNull
    private String failureView = "cas2ServiceFailureView";
    @NotNull
    @Autowired
    @Qualifier(value="defaultArgumentExtractor")
    private ArgumentExtractor argumentExtractor;

    protected Credential getServiceCredentialsFromRequest(WebApplicationService service, HttpServletRequest request) {
        String pgtUrl = request.getParameter("pgtUrl");
        if (StringUtils.hasText((String)pgtUrl)) {
            try {
                RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
                this.verifyRegisteredServiceProperties(registeredService, (Service)service);
                return new HttpBasedServiceCredential(new URL(pgtUrl), registeredService);
            }
            catch (Exception e) {
                this.logger.error("Error constructing pgtUrl", (Throwable)e);
            }
        }
        return null;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        binder.setRequiredFields(new String[]{"renew"});
    }

    private TicketGrantingTicket handleProxyGrantingTicketDelivery(String serviceTicketId, Credential credential) {
        ProxyGrantingTicket proxyGrantingTicketId = null;
        try {
            ServiceTicket serviceTicket = (ServiceTicket)this.centralAuthenticationService.getTicket(serviceTicketId, ServiceTicket.class);
            DefaultAuthenticationContextBuilder builder = new DefaultAuthenticationContextBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
            AuthenticationTransaction transaction = AuthenticationTransaction.wrap((Credential[])new Credential[]{credential});
            this.authenticationSystemSupport.getAuthenticationTransactionManager().handle(transaction, (AuthenticationContextBuilder)builder);
            AuthenticationContext authenticationContext = builder.build(serviceTicket.getService());
            proxyGrantingTicketId = this.centralAuthenticationService.createProxyGrantingTicket(serviceTicketId, authenticationContext);
            this.logger.debug("Generated proxy-granting ticket [{}] off of service ticket [{}] and credential [{}]", new Object[]{proxyGrantingTicketId.getId(), serviceTicketId, credential});
        }
        catch (AuthenticationException authenticationException) {
            this.logger.warn("Failed to authenticate service credential {}", (Object)credential);
        }
        catch (AbstractTicketException e) {
            this.logger.error("Failed to create proxy granting ticket for {}", (Object)credential, (Object)e);
        }
        return proxyGrantingTicketId;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String serviceTicketId;
        WebApplicationService service = this.argumentExtractor.extractService(request);
        String string = serviceTicketId = service != null ? service.getArtifactId() : null;
        if (service == null || serviceTicketId == null) {
            this.logger.debug("Could not identify service and/or service ticket for service: [{}]", (Object)service);
            return this.generateErrorView("INVALID_REQUEST", "INVALID_REQUEST", null, request, service);
        }
        try {
            TicketGrantingTicket proxyGrantingTicketId = null;
            Credential serviceCredential = this.getServiceCredentialsFromRequest(service, request);
            if (serviceCredential != null && (proxyGrantingTicketId = this.handleProxyGrantingTicketDelivery(serviceTicketId, serviceCredential)) == null) {
                return this.generateErrorView("INVALID_PROXY_CALLBACK", "INVALID_PROXY_CALLBACK", new Object[]{serviceCredential.getId()}, request, service);
            }
            Assertion assertion = this.centralAuthenticationService.validateServiceTicket(serviceTicketId, (Service)service);
            if (!this.validateAssertion(request, serviceTicketId, assertion)) {
                return this.generateErrorView("INVALID_TICKET", "INVALID_TICKET", null, request, service);
            }
            String proxyIou = null;
            if (serviceCredential != null && this.proxyHandler.canHandle(serviceCredential) && StringUtils.isEmpty((Object)(proxyIou = this.proxyHandler.handle(serviceCredential, proxyGrantingTicketId)))) {
                return this.generateErrorView("INVALID_PROXY_CALLBACK", "INVALID_PROXY_CALLBACK", new Object[]{serviceCredential.getId()}, request, service);
            }
            this.onSuccessfulValidation(serviceTicketId, assertion);
            this.logger.debug("Successfully validated service ticket {} for service [{}]", (Object)serviceTicketId, (Object)service.getId());
            return this.generateSuccessView(assertion, proxyIou, service, proxyGrantingTicketId);
        }
        catch (AbstractTicketValidationException e) {
            String code = e.getCode();
            return this.generateErrorView(code, "INVALID_TICKET", new Object[]{serviceTicketId, e.getOriginalService().getId(), service.getId()}, request, service);
        }
        catch (AbstractTicketException te) {
            return this.generateErrorView(te.getCode(), "INVALID_TICKET", new Object[]{serviceTicketId}, request, service);
        }
        catch (UnauthorizedProxyingException e) {
            return this.generateErrorView(e.getCode(), "INVALID_REQUEST_PROXY", new Object[]{service.getId()}, request, service);
        }
        catch (UnauthorizedServiceException e) {
            return this.generateErrorView(e.getCode(), "UNAUTHORIZED_SERVICE", null, request, service);
        }
    }

    private boolean validateAssertion(HttpServletRequest request, String serviceTicketId, Assertion assertion) {
        ValidationSpecification validationSpecification = this.getCommandClass();
        ServletRequestDataBinder binder = new ServletRequestDataBinder((Object)validationSpecification, "validationSpecification");
        this.initBinder(request, binder);
        binder.bind((ServletRequest)request);
        if (!validationSpecification.isSatisfiedBy(assertion)) {
            this.logger.debug("Service ticket [{}] does not satisfy validation specification.", (Object)serviceTicketId);
            return false;
        }
        return true;
    }

    protected void onSuccessfulValidation(String serviceTicketId, Assertion assertion) {
    }

    private ModelAndView generateErrorView(String descCode, String errorCode, Object[] args, HttpServletRequest request, WebApplicationService service) {
        ModelAndView modelAndView = this.getModelAndView(false, service);
        String convertedDescription = this.context.getMessage(descCode, args, descCode, request.getLocale());
        modelAndView.addObject("code", (Object)StringEscapeUtils.escapeHtml4((String)errorCode));
        modelAndView.addObject("description", (Object)StringEscapeUtils.escapeHtml4((String)convertedDescription));
        return modelAndView;
    }

    private ModelAndView getModelAndView(boolean isSuccess, WebApplicationService service) {
        if (service != null && service.getFormat() == ValidationResponseType.JSON) {
            return new ModelAndView(DEFAULT_SERVICE_VIEW_NAME_JSON);
        }
        return new ModelAndView(isSuccess ? this.successView : this.failureView);
    }

    private ModelAndView generateSuccessView(Assertion assertion, String proxyIou, WebApplicationService service, TicketGrantingTicket proxyGrantingTicket) {
        Map<String, ?> augmentedModelObjects;
        ModelAndView modelAndView = this.getModelAndView(true, service);
        modelAndView.addObject("assertion", (Object)assertion);
        modelAndView.addObject("service", (Object)service);
        modelAndView.addObject("pgtIou", (Object)proxyIou);
        if (proxyGrantingTicket != null) {
            modelAndView.addObject("proxyGrantingTicket", (Object)proxyGrantingTicket.getId());
        }
        if ((augmentedModelObjects = this.augmentSuccessViewModelObjects(assertion)) != null) {
            modelAndView.addAllObjects(augmentedModelObjects);
        }
        return modelAndView;
    }

    protected Map<String, ?> augmentSuccessViewModelObjects(Assertion assertion) {
        return Collections.emptyMap();
    }

    private ValidationSpecification getCommandClass() {
        try {
            return (ValidationSpecification)this.validationSpecificationClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public final void setArgumentExtractor(ArgumentExtractor argumentExtractor) {
        this.argumentExtractor = argumentExtractor;
    }

    public void setValidationSpecificationClass(Class<?> validationSpecificationClass) {
        this.validationSpecificationClass = validationSpecificationClass;
    }

    public void setFailureView(String failureView) {
        this.failureView = failureView;
    }

    public void setSuccessView(String successView) {
        this.successView = successView;
    }

    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    public final void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    private void verifyRegisteredServiceProperties(RegisteredService registeredService, Service service) {
        if (registeredService == null) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not found in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not enabled in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
    }

    public void setAuthenticationSystemSupport(AuthenticationSystemSupport authenticationSystemSupport) {
        this.authenticationSystemSupport = authenticationSystemSupport;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }
}

