/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.pac4j.web.flow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.support.pac4j.authentication.principal.ClientCredential;
import org.jasig.cas.web.support.WebUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.Protocol;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.ProfileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class ClientAction
extends AbstractAction {
    private final Logger logger = LoggerFactory.getLogger(ClientAction.class);
    public static final String SERVICE = "service";
    public static final String THEME = "theme";
    public static final String LOCALE = "locale";
    public static final String METHOD = "method";
    @NotNull
    private final Clients clients;
    @NotNull
    private final CentralAuthenticationService centralAuthenticationService;

    public ClientAction(CentralAuthenticationService theCentralAuthenticationService, Clients theClients) {
        this.centralAuthenticationService = theCentralAuthenticationService;
        this.clients = theClients;
        ProfileHelper.setKeepRawData((boolean)true);
    }

    protected Event doExecute(RequestContext context) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        HttpSession session = request.getSession();
        J2EContext webContext = new J2EContext(request, response);
        String clientName = request.getParameter(this.clients.getClientNameParameter());
        this.logger.debug("clientName : {}", (Object)clientName);
        if (StringUtils.isNotBlank((String)clientName)) {
            Credentials credentials;
            BaseClient client = (BaseClient)this.clients.findClient(clientName);
            this.logger.debug("client : {}", (Object)client);
            if (client.getProtocol() == Protocol.HTTP) {
                throw new TechnicalException("HTTP protocol client not supported : " + client);
            }
            try {
                credentials = client.getCredentials((WebContext)webContext);
                this.logger.debug("credentials : {}", (Object)credentials);
            }
            catch (RequiresHttpAction e) {
                this.logger.info("requires http action : {}", (Throwable)e);
                response.flushBuffer();
                ExternalContext externalContext = ExternalContextHolder.getExternalContext();
                externalContext.recordResponseComplete();
                return new Event((Object)this, "stop");
            }
            Service service = (Service)session.getAttribute(SERVICE);
            context.getFlowScope().put(SERVICE, (Object)service);
            this.restoreRequestAttribute(request, session, THEME);
            this.restoreRequestAttribute(request, session, LOCALE);
            this.restoreRequestAttribute(request, session, METHOD);
            if (credentials != null) {
                WebUtils.putTicketGrantingTicketInRequestScope((RequestContext)context, (String)this.centralAuthenticationService.createTicketGrantingTicket(new Credential[]{new ClientCredential(credentials)}));
                return this.success();
            }
        }
        this.prepareForLoginPage(context);
        return this.error();
    }

    protected void prepareForLoginPage(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        HttpSession session = request.getSession();
        J2EContext webContext = new J2EContext(request, response);
        Service service = (Service)context.getFlowScope().get(SERVICE);
        if (service != null) {
            session.setAttribute(SERVICE, (Object)service);
        }
        this.saveRequestParameter(request, session, THEME);
        this.saveRequestParameter(request, session, LOCALE);
        this.saveRequestParameter(request, session, METHOD);
        for (Client client : this.clients.findAllClients()) {
            String key = client.getName() + "Url";
            String redirectionUrl = client.getRedirectionUrl((WebContext)webContext);
            this.logger.debug("{} -> {}", (Object)key, (Object)redirectionUrl);
            context.getFlowScope().put(key, (Object)redirectionUrl);
        }
    }

    private void restoreRequestAttribute(HttpServletRequest request, HttpSession session, String name) {
        String value = (String)session.getAttribute(name);
        request.setAttribute(name, (Object)value);
    }

    private void saveRequestParameter(HttpServletRequest request, HttpSession session, String name) {
        String value = request.getParameter(name);
        if (value != null) {
            session.setAttribute(name, (Object)value);
        }
    }
}

