/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.generic.remote;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.adaptors.generic.remote.RemoteAddressCredential;
import org.jasig.cas.authentication.AbstractAuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.HandlerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="remoteAddressAuthenticationHandler")
public final class RemoteAddressAuthenticationHandler
extends AbstractAuthenticationHandler {
    private static final int HEX_RIGHT_SHIFT_COEFFICIENT = 255;
    private final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private InetAddress inetNetmask;
    private InetAddress inetNetwork;

    public HandlerResult authenticate(Credential credential) throws GeneralSecurityException {
        RemoteAddressCredential c = (RemoteAddressCredential)credential;
        if (this.inetNetmask != null && this.inetNetwork != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(c.getRemoteAddress().trim());
                if (this.containsAddress(this.inetNetwork, this.inetNetmask, inetAddress)) {
                    return new DefaultHandlerResult((AuthenticationHandler)this, (CredentialMetaData)c, this.principalFactory.createPrincipal(c.getId()));
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.logger.debug("Unknown host {}", (Object)c.getRemoteAddress());
            }
        }
        throw new FailedLoginException(String.valueOf(c.getRemoteAddress()) + " not in allowed range.");
    }

    public boolean supports(Credential credential) {
        return credential instanceof RemoteAddressCredential;
    }

    private boolean containsAddress(InetAddress network, InetAddress netmask, InetAddress ip) {
        this.logger.debug("Checking IP address: {} in {} by {}", new Object[]{ip, network, netmask});
        byte[] networkBytes = network.getAddress();
        byte[] netmaskBytes = netmask.getAddress();
        byte[] ipBytes = ip.getAddress();
        if (networkBytes.length != netmaskBytes.length || netmaskBytes.length != ipBytes.length) {
            this.logger.debug("Network address {}, subnet mask {} and/or host address {} have different sizes! (return false ...)", new Object[]{network, netmask, ip});
            return false;
        }
        int i = 0;
        while (i < netmaskBytes.length) {
            int mask = netmaskBytes[i] & 0xFF;
            if ((networkBytes[i] & mask) != (ipBytes[i] & mask)) {
                this.logger.debug("{} is not in {}/{}", new Object[]{ip, network, netmask});
                return false;
            }
            ++i;
        }
        this.logger.debug("{} is in {}/{}", new Object[]{ip, network, netmask});
        return true;
    }

    @Autowired
    public void setIpNetworkRange(@Value(value="${ip.address.range:}") String ipAddressRange) {
        String[] splitAddress;
        if (StringUtils.isNotBlank((CharSequence)ipAddressRange) && (splitAddress = ipAddressRange.split("/")).length == 2) {
            String network = splitAddress[0].trim();
            String netmask = splitAddress[1].trim();
            try {
                this.inetNetwork = InetAddress.getByName(network);
                this.logger.debug("InetAddress network: {}", (Object)this.inetNetwork.toString());
            }
            catch (UnknownHostException e) {
                this.logger.error("The network address was not valid: {}", (Object)e.getMessage());
            }
            try {
                this.inetNetmask = InetAddress.getByName(netmask);
                this.logger.debug("InetAddress netmask: {}", (Object)this.inetNetmask.toString());
            }
            catch (UnknownHostException e) {
                this.logger.error("The network netmask was not valid: {}", (Object)e.getMessage());
            }
        }
    }
}

