/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.generic;

import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.jasig.cas.authentication.AccountDisabledException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.RememberMeUsernamePasswordCredential;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="shiroAuthenticationHandler")
public class ShiroAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private Set<String> requiredRoles = new HashSet<String>();
    private Set<String> requiredPermissions = new HashSet<String>();
    @Value(value="${shiro.authn.requiredRoles:}")
    private String requiredRolesConfig;
    @Value(value="${shiro.authn.requiredPermissions:}")
    private String requiredPermissionsConfig;

    @PostConstruct
    public void init() {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.requiredPermissionsConfig)) {
            this.setRequiredPermissions(StringUtils.commaDelimitedListToSet((String)this.requiredPermissionsConfig));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.requiredRolesConfig)) {
            this.setRequiredRoles(StringUtils.commaDelimitedListToSet((String)this.requiredRolesConfig));
        }
    }

    public void setRequiredRoles(Set<String> requiredRoles) {
        this.requiredRoles = requiredRoles;
    }

    public void setRequiredPermissions(Set<String> requiredPermissions) {
        this.requiredPermissions = requiredPermissions;
    }

    @Autowired
    public void setShiroConfiguration(@Value(value="${shiro.authn.config.file:classpath:shiro.ini}") Resource resource) {
        try {
            if (resource.exists()) {
                String location = resource.getURI().toString();
                this.logger.debug("Loading Shiro configuration from {}", (Object)location);
                IniSecurityManagerFactory factory = new IniSecurityManagerFactory(location);
                SecurityManager securityManager = (SecurityManager)factory.getInstance();
                SecurityUtils.setSecurityManager((SecurityManager)securityManager);
            } else {
                this.logger.debug("Shiro configuration is not defined");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential transformedCredential) throws GeneralSecurityException, PreventedException {
        try {
            RememberMeUsernamePasswordCredential credential = (RememberMeUsernamePasswordCredential)transformedCredential;
            UsernamePasswordToken token = new UsernamePasswordToken(credential.getUsername(), this.getPasswordEncoder().encode(credential.getPassword()));
            token.setRememberMe(credential.isRememberMe());
            Subject currentUser = this.getCurrentExecutingSubject();
            currentUser.login((AuthenticationToken)token);
            this.checkSubjectRolesAndPermissions(currentUser);
            return this.createAuthenticatedSubjectResult((Credential)credential, currentUser);
        }
        catch (UnknownAccountException uae) {
            throw new AccountNotFoundException(uae.getMessage());
        }
        catch (IncorrectCredentialsException ice) {
            throw new FailedLoginException(ice.getMessage());
        }
        catch (LockedAccountException lae) {
            throw new AccountLockedException(lae.getMessage());
        }
        catch (ExcessiveAttemptsException eae) {
            throw new AccountLockedException(eae.getMessage());
        }
        catch (ExpiredCredentialsException eae) {
            throw new CredentialExpiredException(eae.getMessage());
        }
        catch (DisabledAccountException eae) {
            throw new AccountDisabledException(eae.getMessage());
        }
        catch (AuthenticationException ae) {
            throw new FailedLoginException(ae.getMessage());
        }
    }

    protected void checkSubjectRolesAndPermissions(Subject currentUser) throws FailedLoginException {
        if (this.requiredRoles != null) {
            for (String role : this.requiredRoles) {
                if (currentUser.hasRole(role)) continue;
                throw new FailedLoginException("Required role " + role + " does not exist");
            }
        }
        if (this.requiredPermissions != null) {
            for (String perm : this.requiredPermissions) {
                if (currentUser.isPermitted(perm)) continue;
                throw new FailedLoginException("Required permission " + perm + " does not exist");
            }
        }
    }

    protected HandlerResult createAuthenticatedSubjectResult(Credential credential, Subject currentUser) {
        String username = currentUser.getPrincipal().toString();
        return this.createHandlerResult(credential, this.principalFactory.createPrincipal(username), null);
    }

    protected Subject getCurrentExecutingSubject() {
        return SecurityUtils.getSubject();
    }

    public boolean supports(Credential credential) {
        return credential instanceof RememberMeUsernamePasswordCredential;
    }
}

