/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.generic;

import java.security.GeneralSecurityException;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="rejectUsersAuthenticationHandler")
public class RejectUsersAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @Value(value="${reject.authn.users:}")
    private String rejectedUsersConfig;
    private Set<String> users;

    @PostConstruct
    public void init() {
        if (StringUtils.isNotBlank((CharSequence)this.rejectedUsersConfig) && this.users == null) {
            this.setUsers(org.springframework.util.StringUtils.commaDelimitedListToSet((String)this.rejectedUsersConfig));
        }
    }

    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        String username = credential.getUsername();
        if (this.users.contains(username)) {
            throw new FailedLoginException();
        }
        return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), null);
    }

    public final void setUsers(@NotNull Set<String> users) {
        this.users = users;
    }
}

