/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.generic;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component(value="fileAuthenticationHandler")
public class FileAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_SEPARATOR = "::";
    @NotNull
    private String separator = "::";
    private Resource fileName;

    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        try {
            if (this.fileName == null || !this.fileName.exists()) {
                throw new FileNotFoundException("Filename does not exist");
            }
            String username = credential.getUsername();
            String passwordOnRecord = this.getPasswordOnRecord(username);
            if (StringUtils.isBlank((CharSequence)passwordOnRecord)) {
                throw new AccountNotFoundException(String.valueOf(username) + " not found in backing file.");
            }
            String password = credential.getPassword();
            if (StringUtils.isNotBlank((CharSequence)password) && this.getPasswordEncoder().encode(password).equals(passwordOnRecord)) {
                return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), null);
            }
        }
        catch (IOException e) {
            throw new PreventedException("IO error reading backing file", (Throwable)e);
        }
        throw new FailedLoginException();
    }

    @Autowired
    public final void setFileName(@Value(value="${file.authn.filename:}") Resource fileName) {
        this.fileName = fileName;
    }

    @Autowired
    public final void setSeparator(@Value(value="${file.authn.separator:::}") String separator) {
        this.separator = separator;
    }

    /*
     * Unable to fully structure code
     */
    private String getPasswordOnRecord(String username) throws IOException {
        var2_2 = null;
        var3_4 = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.fileName.getInputStream(), Charset.defaultCharset()));
            try {
                line = bufferedReader.readLine();
                while (true) {
                    lineFields = line.split(this.separator);
                    userOnRecord = lineFields[0];
                    passOnRecord = lineFields[1];
                    if (username.equals(userOnRecord)) {
                        return passOnRecord;
                    }
                    line = bufferedReader.readLine();
                    return line;
                }
            }
            finally {
                if (line != null) ** continue;
            }
        }
        catch (Throwable var3_5) {
            if (var2_2 == null) {
                var2_2 = var3_5;
            } else if (var2_2 != var3_5) {
                var2_2.addSuppressed(var3_5);
            }
            throw var2_2;
        }
        return null;
    }
}

