/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.DerivedTableReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SybaseASELegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private static final String UNION_ALL = " union all ";

    public SybaseASELegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected void visitInsertStatementOnly(InsertSelectStatement statement) {
        if (statement.getConflictClause() == null || statement.getConflictClause().isDoNothing()) {
            super.visitInsertStatementOnly(statement);
        } else {
            this.visitInsertStatementEmulateMerge(statement);
        }
    }

    protected void renderDeleteClause(DeleteStatement statement) {
        this.appendSql("delete ");
        Stack clauseStack = this.getClauseStack();
        try {
            clauseStack.push((Object)Clause.DELETE);
            this.renderDmlTargetTableExpression(statement.getTargetTable());
            if (statement.getFromClause().getRoots().isEmpty()) {
                this.appendSql(" from ");
                this.renderDmlTargetTableExpression(statement.getTargetTable());
                this.renderTableReferenceIdentificationVariable((TableReference)statement.getTargetTable());
            } else {
                this.visitFromClause(statement.getFromClause());
            }
        }
        finally {
            clauseStack.pop();
        }
    }

    protected void renderUpdateClause(UpdateStatement updateStatement) {
        this.appendSql("update ");
        Stack clauseStack = this.getClauseStack();
        try {
            clauseStack.push((Object)Clause.UPDATE);
            this.renderDmlTargetTableExpression(updateStatement.getTargetTable());
        }
        finally {
            clauseStack.pop();
        }
    }

    protected boolean supportsJoinsInDelete() {
        return true;
    }

    protected void renderFromClauseAfterUpdateSet(UpdateStatement statement) {
        if (statement.getFromClause().getRoots().isEmpty()) {
            this.appendSql(" from ");
            this.renderDmlTargetTableExpression(statement.getTargetTable());
            this.renderTableReferenceIdentificationVariable((TableReference)statement.getTargetTable());
        } else {
            this.visitFromClause(statement.getFromClause());
        }
    }

    protected void visitConflictClause(ConflictClause conflictClause) {
        if (conflictClause != null && conflictClause.isDoUpdate() && conflictClause.getConstraintName() != null) {
            throw new IllegalQueryOperationException("Insert conflict 'do update' clause with constraint name is not supported");
        }
    }

    protected boolean supportsWithClause() {
        return false;
    }

    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSearchedExpression)) {
            List whenFragments = caseSearchedExpression.getWhenFragments();
            Expression firstResult = ((CaseSearchedExpression.WhenFragment)whenFragments.get(0)).getResult();
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, resultRenderer);
        }
    }

    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSimpleExpression)) {
            List whenFragments = caseSimpleExpression.getWhenFragments();
            Expression firstResult = ((CaseSimpleExpression.WhenFragment)whenFragments.get(0)).getResult();
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, resultRenderer);
        }
    }

    protected boolean renderNamedTableReference(NamedTableReference tableReference, LockMode lockMode) {
        String tableExpression = tableReference.getTableExpression();
        if (tableReference instanceof UnionTableReference && lockMode != LockMode.NONE && tableExpression.charAt(0) == '(') {
            int unionIndex;
            int searchIndex = 0;
            while ((unionIndex = tableExpression.indexOf(UNION_ALL, searchIndex)) != -1) {
                this.append(tableExpression, searchIndex, unionIndex);
                this.renderLockHint(lockMode);
                this.appendSql(UNION_ALL);
                searchIndex = unionIndex + UNION_ALL.length();
            }
            this.append(tableExpression, searchIndex, tableExpression.length() - 1);
            this.renderLockHint(lockMode);
            this.appendSql(" )");
            this.registerAffectedTable(tableReference);
            this.renderTableReferenceIdentificationVariable((TableReference)tableReference);
        } else {
            super.renderNamedTableReference(tableReference, lockMode);
            this.renderLockHint(lockMode);
        }
        return true;
    }

    private void renderLockHint(LockMode lockMode) {
        int effectiveLockTimeout = this.getEffectiveLockTimeout(lockMode);
        block0 : switch (lockMode) {
            case PESSIMISTIC_READ: 
            case PESSIMISTIC_WRITE: 
            case WRITE: {
                switch (effectiveLockTimeout) {
                    case -2: {
                        this.appendSql(" holdlock readpast");
                        break block0;
                    }
                }
                this.appendSql(" holdlock");
                break;
            }
            case UPGRADE_SKIPLOCKED: {
                this.appendSql(" holdlock readpast");
                break;
            }
            case UPGRADE_NOWAIT: {
                this.appendSql(" holdlock");
            }
        }
    }

    protected void renderTableGroupJoin(TableGroupJoin tableGroupJoin, List<TableGroupJoin> tableGroupJoinCollector) {
        this.appendSql(' ');
        if (tableGroupJoin.getJoinType() != SqlAstJoinType.CROSS) {
            this.appendSql(tableGroupJoin.getJoinType().getText());
        }
        this.appendSql("join ");
        Object predicate = tableGroupJoin.getPredicate() == null ? new BooleanExpressionPredicate((Expression)new QueryLiteral((Object)true, (SqlExpressible)this.getBooleanType())) : tableGroupJoin.getPredicate();
        if (predicate != null && !predicate.isEmpty()) {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), (Predicate)predicate, tableGroupJoinCollector);
        } else {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), null, tableGroupJoinCollector);
        }
    }

    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        return AbstractSqlAstTranslator.LockStrategy.CLAUSE;
    }

    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        if (this.supportsTopClause()) {
            this.renderTopClause((QuerySpec)this.getQueryPartStack().getCurrent(), true, false);
        }
        super.visitSqlSelections(selectClause);
    }

    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsLiteral(fetchClauseExpression, offsetClauseExpression, offset);
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (queryGroup.hasSortSpecifications() || queryGroup.hasOffsetOrFetchClause()) {
            this.appendSql("select ");
            this.renderTopClause(queryGroup.getOffsetClauseExpression(), queryGroup.getFetchClauseExpression(), queryGroup.getFetchClauseType(), true, false);
            this.appendSql("* from (");
            this.renderQueryGroup(queryGroup, false);
            this.appendSql(") grp_(c0");
            int itemCount = queryGroup.getFirstQuerySpec().getSelectClause().getSqlSelections().size();
            for (int i = 1; i < itemCount; ++i) {
                this.appendSql(",c");
                this.appendSql(i);
            }
            this.appendSql(')');
            this.visitOrderBy(queryGroup.getSortSpecifications());
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    protected void visitValuesList(List<Values> valuesList) {
        this.visitValuesListEmulateSelectUnion(valuesList);
    }

    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.append('(');
        this.visitValuesListEmulateSelectUnion(tableReference.getValuesList());
        this.append(')');
        this.renderDerivedTableReference((DerivedTableReference)tableReference);
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        this.assertRowsOnlyFetchClauseType(queryPart);
        if (!queryPart.isRoot() && queryPart.hasOffsetOrFetchClause() && (queryPart.getFetchClauseExpression() != null && !this.supportsTopClause() || queryPart.getOffsetClauseExpression() != null)) {
            throw new IllegalArgumentException("Can't emulate offset fetch clause in subquery");
        }
    }

    protected void renderFetchExpression(Expression fetchExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderFetchExpression(fetchExpression);
        } else {
            this.renderExpressionAsLiteral(fetchExpression, this.getJdbcParameterBindings());
        }
    }

    protected void renderOffsetExpression(Expression offsetExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderOffsetExpression(offsetExpression);
        } else {
            this.renderExpressionAsLiteral(offsetExpression, this.getJdbcParameterBindings());
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        if (this.getDialect().isAnsiNullOn()) {
            if (this.supportsDistinctFromPredicate()) {
                this.renderComparisonEmulateIntersect(lhs, operator, rhs);
            } else {
                this.renderComparisonEmulateCase(lhs, operator, rhs);
            }
        } else {
            boolean lhsNotNullPredicate;
            boolean rhsNotNullPredicate = lhs instanceof Literal || this.isParameter(lhs);
            boolean bl = lhsNotNullPredicate = rhs instanceof Literal || this.isParameter(rhs);
            if (rhsNotNullPredicate || lhsNotNullPredicate) {
                lhs.accept((SqlAstWalker)this);
                switch (operator) {
                    case DISTINCT_FROM: {
                        this.appendSql("<>");
                        break;
                    }
                    case NOT_DISTINCT_FROM: {
                        this.appendSql('=');
                        break;
                    }
                    case LESS_THAN: 
                    case GREATER_THAN: 
                    case LESS_THAN_OR_EQUAL: 
                    case GREATER_THAN_OR_EQUAL: {
                        lhsNotNullPredicate = false;
                        rhsNotNullPredicate = false;
                    }
                    default: {
                        this.appendSql(operator.sqlText());
                    }
                }
                rhs.accept((SqlAstWalker)this);
                if (lhsNotNullPredicate) {
                    this.appendSql(" and ");
                    lhs.accept((SqlAstWalker)this);
                    this.appendSql(" is not null");
                }
                if (rhsNotNullPredicate) {
                    this.appendSql(" and ");
                    rhs.accept((SqlAstWalker)this);
                    this.appendSql(" is not null");
                }
            } else if (this.supportsDistinctFromPredicate()) {
                this.renderComparisonEmulateIntersect(lhs, operator, rhs);
            } else {
                this.renderComparisonEmulateCase(lhs, operator, rhs);
            }
        }
    }

    protected boolean supportsIntersect() {
        return false;
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("dummy_.x");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.appendSql('(');
        this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
        this.appendSql(')');
    }

    protected String determineColumnReferenceQualifier(ColumnReference columnReference) {
        List roots;
        String dmlAlias;
        MutationStatement currentDmlStatement;
        DmlTargetColumnQualifierSupport qualifierSupport = this.getDialect().getDmlTargetColumnQualifierSupport();
        if (qualifierSupport == DmlTargetColumnQualifierSupport.TABLE_ALIAS || (currentDmlStatement = this.getCurrentDmlStatement()) == null || (dmlAlias = currentDmlStatement.getTargetTable().getIdentificationVariable()) == null || !dmlAlias.equals(columnReference.getQualifier())) {
            return columnReference.getQualifier();
        }
        QuerySpec currentQuerySpec = (QuerySpec)this.getQueryPartStack().getCurrent();
        if (currentQuerySpec != null && !currentQuerySpec.isRoot() && (roots = currentQuerySpec.getFromClause().getRoots()).size() == 1 && ((TableGroup)roots.get(0)).getPrimaryTableReference() instanceof UnionTableReference) {
            return columnReference.getQualifier();
        }
        if (columnReference.isColumnExpressionFormula()) {
            return null;
        }
        return this.getCurrentDmlStatement().getTargetTable().getTableExpression();
    }

    protected boolean needsRowsToSkip() {
        return true;
    }

    protected boolean needsMaxRows() {
        return !this.supportsTopClause();
    }

    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    protected String getDual() {
        return "(select 1 c1)";
    }

    private boolean supportsTopClause() {
        return this.getDialect().getVersion().isSameOrAfter(12, 5);
    }

    private boolean supportsParameterOffsetFetchExpression() {
        return false;
    }
}

